/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.singlecontainer;

import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.singlecontainer.SingleContainerIterator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;

public final class SingleContainer<E>
extends AbstractExtendedContainer<E> {
    private final E element;

    private SingleContainer(E element) {
        Validator.assertThat(element).thatIsNamed("element").isNotNull();
        this.element = element;
    }

    public static <T> SingleContainer<T> withElement(T element) {
        return new SingleContainer<T>(element);
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        Validator.assertThat(oneBasedIndex).thatIsNamed("one-based index").isEqualTo(1);
        return this.element;
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return SingleContainerIterator.forNullableElement(this.element);
    }
}

