/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.document.node;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.AbstractNode;
import ch.nolix.core.document.node.MutableNode;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;

public final class Node
extends AbstractNode<Node> {
    public static final Node EMPTY_NODE = new Node();
    private final String nullableHeader;
    private final ImmutableList<Node> childNodes;

    private Node() {
        this.nullableHeader = null;
        this.childNodes = ImmutableList.fromIterable(LinkedList.createEmpty());
    }

    private Node(Iterable<? extends INode<?>> childNodes) {
        this.nullableHeader = null;
        this.childNodes = ImmutableList.fromIterable(Node.createNodesFromNodes(childNodes));
    }

    private Node(String header) {
        this.nullableHeader = Node.getValidHeaderFromHeader(header);
        this.childNodes = ImmutableList.createEmpty();
    }

    private Node(String header, INode<?> childNode, INode<?>[] childNodes) {
        this.nullableHeader = Node.getValidHeaderFromHeader(header);
        this.childNodes = ImmutableList.fromIterable(Node.createNodesFromNodes(ContainerView.forElementAndArray(childNode, childNodes)));
    }

    private Node(String header, Iterable<? extends INode<?>> childNodes) {
        this.nullableHeader = Node.getValidHeaderFromHeader(header);
        this.childNodes = ImmutableList.fromIterable(Node.createNodesFromNodes(childNodes));
    }

    public static Node fromEnum(Enum<?> pEnum) {
        return Node.withHeaderAndChildNode(Node.getTypeNameOfEnum(pEnum), Node.withHeader(pEnum.name()), new INode[0]);
    }

    public static Node fromFile(String filePath) {
        return Node.fromNode(MutableNode.fromFile(filePath));
    }

    public static Node fromNode(INode<?> node) {
        if (node instanceof Node) {
            Node lNode = (Node)node;
            return lNode;
        }
        if (!node.hasHeader()) {
            return Node.withChildNodes(node.getStoredChildNodes());
        }
        return Node.withHeaderAndChildNodes(node.getHeader(), node.getStoredChildNodes());
    }

    public static Node fromString(String string) {
        return Node.fromNode(MutableNode.fromString(string));
    }

    public static Node withChildNode(boolean childNode) {
        return Node.withChildNode(Node.withHeader(childNode), new INode[0]);
    }

    public static Node withChildNode(double childNode) {
        return Node.withChildNode(Node.withHeader(childNode), new INode[0]);
    }

    public static Node withChildNode(INode<?> childNode, INode<?> ... childNodes) {
        ContainerView<INode<?>> allChildNodes = ContainerView.forElementAndArray(childNode, childNodes);
        return new Node(allChildNodes);
    }

    public static Node withChildNode(long childNode) {
        return Node.withChildNode(Node.withHeader(childNode), new INode[0]);
    }

    public static Node withChildNode(String childNode, String ... childNodes) {
        IContainer<Node> allChildNodes = ContainerView.forElementAndArray(childNode, childNodes).getViewOf(Node::withHeader);
        return Node.withChildNodes(allChildNodes);
    }

    public static Node withChildNodes(Iterable<? extends INode<?>> childNodes) {
        return new Node(childNodes);
    }

    public static Node withHeader(boolean header) {
        return Node.withHeader(String.valueOf(header));
    }

    public static Node withHeader(double header) {
        return Node.withHeader(String.valueOf(header));
    }

    public static Node withHeader(long header) {
        return Node.withHeader(String.valueOf(header));
    }

    public static Node withHeader(String header) {
        return new Node(header);
    }

    public static Node withHeaderAndChildNode(String header, boolean childNode) {
        return Node.withHeaderAndChildNode(header, Node.withHeader(childNode), new INode[0]);
    }

    public static Node withHeaderAndChildNode(String header, double childNode) {
        return Node.withHeaderAndChildNode(header, Node.withHeader(childNode), new INode[0]);
    }

    public static Node withHeaderAndChildNode(String header, INode<?> childNode, INode<?> ... childNodes) {
        return new Node(header, childNode, childNodes);
    }

    public static Node withHeaderAndChildNode(String header, long childNode) {
        return Node.withHeaderAndChildNode(header, Node.withHeader(childNode), new INode[0]);
    }

    public static Node withHeaderAndChildNode(String header, String childNode, String ... childNodes) {
        IContainer<Node> allChildNodes = ContainerView.forElementAndArray(childNode, childNodes).getViewOf(Node::withHeader);
        return Node.withHeaderAndChildNodes(header, allChildNodes);
    }

    public static Node withHeaderAndChildNodes(String header, Iterable<? extends INode<?>> childNodes) {
        return new Node(header, childNodes);
    }

    private static IContainer<Node> createNodesFromNodes(Iterable<? extends INode<?>> nodes) {
        LinkedList<Node> lNodes = LinkedList.createEmpty();
        for (INode<?> n : nodes) {
            lNodes.addAtEnd(Node.fromNode(n));
        }
        return lNodes;
    }

    private static String getTypeNameOfEnum(Enum<?> pEnum) {
        return pEnum.getClass().getSimpleName();
    }

    private static String getValidHeaderFromHeader(String header) {
        Validator.assertThat(header).thatIsNamed("header").isNotBlank();
        return header;
    }

    @Override
    public INode<?> asWithHeader(String header) {
        return Node.withHeaderAndChildNodes(header, this.getStoredChildNodes());
    }

    @Override
    public String getHeader() {
        if (this.nullableHeader == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "header");
        }
        return this.nullableHeader;
    }

    @Override
    public IContainer<Node> getStoredChildNodes() {
        return this.childNodes;
    }

    @Override
    public boolean hasHeader() {
        return this.nullableHeader != null;
    }
}

