/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.document.xml;

import ch.nolix.core.commontypetool.stringtool.StringTool;
import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.xml.XmlAttribute;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.xml.IMutableXmlNode;
import ch.nolix.coreapi.document.xml.IXmlAttribute;
import ch.nolix.coreapi.document.xml.IXmlNode;

public final class MutableXmlNode
implements IMutableXmlNode {
    private String memberName;
    private String memberValue;
    private final LinkedList<IXmlAttribute> memberAttributes = LinkedList.createEmpty();
    private final LinkedList<IMutableXmlNode> memberChildNodes = LinkedList.createEmpty();

    private MutableXmlNode() {
    }

    public static MutableXmlNode createBlankMutableXmlNode() {
        return new MutableXmlNode();
    }

    public static MutableXmlNode fromXmlNode(IXmlNode<?> pXmlNode) {
        MutableXmlNode mutableXmlNode = new MutableXmlNode();
        if (pXmlNode.hasName()) {
            mutableXmlNode.setName(pXmlNode.getName());
        }
        mutableXmlNode.addAttributes(pXmlNode.getAttributes());
        for (IXmlNode c : pXmlNode.getStoredChildNodes()) {
            mutableXmlNode.addChildNode(MutableXmlNode.fromXmlNode(c));
        }
        if (pXmlNode.hasValue()) {
            mutableXmlNode.setValue((String)pXmlNode.getValue());
        }
        return mutableXmlNode;
    }

    private static String toFormatedString(IMutableXmlNode mutableXmlNode, int leadingTabulatorCount) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringTool.createTabs(leadingTabulatorCount)).append('<').append(mutableXmlNode.getName());
        if (mutableXmlNode.containsAttributes()) {
            stringBuilder.append(' ').append(mutableXmlNode.getAttributes().toStringWithSeparator(' '));
        }
        stringBuilder.append('>');
        if (mutableXmlNode.hasValue()) {
            if (!mutableXmlNode.hasMixedContent()) {
                stringBuilder.append((String)mutableXmlNode.getValue());
            } else {
                stringBuilder.append('\n').append(StringTool.createTabs(leadingTabulatorCount + 1)).append((String)mutableXmlNode.getValue()).append('\n');
            }
        }
        if (mutableXmlNode.containsChildNodes()) {
            for (IMutableXmlNode c : mutableXmlNode.getStoredChildNodes()) {
                stringBuilder.append('\n').append(MutableXmlNode.toFormatedString(c, leadingTabulatorCount + 1));
            }
            stringBuilder.append('\n');
        }
        if (mutableXmlNode.containsChildNodes()) {
            stringBuilder.append(StringTool.createTabs(leadingTabulatorCount));
        }
        stringBuilder.append("</").append(mutableXmlNode.getName()).append('>');
        return stringBuilder.toString();
    }

    @Override
    public MutableXmlNode addAttribute(IXmlAttribute attribute) {
        this.memberAttributes.addAtEnd(attribute);
        return this;
    }

    @Override
    public MutableXmlNode addAttributes(IXmlAttribute attribute, IXmlAttribute ... attributes) {
        this.addAttribute(attribute);
        return this.addAttributes(ContainerView.forArray(attributes));
    }

    public MutableXmlNode addAttributes(Iterable<IXmlAttribute> attributes) {
        this.memberAttributes.addAtEnd(attributes);
        return this;
    }

    @Override
    public IMutableXmlNode addAttributeWithNameAndValue(String name, String value) {
        return this.addAttribute(new XmlAttribute(name, value));
    }

    @Override
    public MutableXmlNode addChildNode(IMutableXmlNode childNode) {
        this.memberChildNodes.addAtEnd(childNode);
        return this;
    }

    @Override
    public MutableXmlNode addChildNodes(IMutableXmlNode childNode, IMutableXmlNode ... childNodes) {
        this.addChildNode(childNode);
        return this.addChildNodes(ContainerView.forArray(childNodes));
    }

    public MutableXmlNode addChildNodes(Iterable<IMutableXmlNode> childNodes) {
        this.memberChildNodes.addAtEnd(childNodes);
        return this;
    }

    @Override
    public boolean containsAttributes() {
        return this.memberAttributes.containsAny();
    }

    @Override
    public boolean containsChildNodes() {
        return this.memberChildNodes.containsAny();
    }

    @Override
    public IContainer<IXmlAttribute> getAttributes() {
        return this.memberAttributes;
    }

    public int getAttributeCount() {
        return this.memberAttributes.getCount();
    }

    public int getChildNodeCount() {
        return this.memberChildNodes.getCount();
    }

    @Override
    public String getName() {
        if (this.memberName == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "name");
        }
        return this.memberName;
    }

    @Override
    public IContainer<IMutableXmlNode> getStoredChildNodes() {
        return this.memberChildNodes;
    }

    @Override
    public String getValue() {
        this.supposeHasValue();
        return this.memberValue;
    }

    @Override
    public boolean hasMixedContent() {
        return this.hasValue() && this.containsChildNodes();
    }

    @Override
    public boolean hasName() {
        return this.memberName != null;
    }

    @Override
    public boolean hasValue() {
        return this.memberValue != null;
    }

    public IMutableXmlNode removeAttributes() {
        this.memberAttributes.clear();
        return this;
    }

    public IMutableXmlNode removeChildNodes() {
        this.memberChildNodes.clear();
        return this;
    }

    @Override
    public void removeName() {
        this.memberName = null;
    }

    @Override
    public void removeValue() {
        this.memberValue = null;
    }

    @Override
    public IMutableXmlNode setName(String name) {
        Validator.assertThat(name).thatIsNamed("name").isNotBlank();
        this.memberName = name;
        return this;
    }

    @Override
    public IMutableXmlNode setValue(String value) {
        Validator.assertThat(value).isNotEmpty();
        this.memberValue = value;
        return this;
    }

    public String toFormatedString() {
        return MutableXmlNode.toFormatedString(this, 0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<').append(this.getName());
        if (this.containsAttributes()) {
            stringBuilder.append(' ').append(this.getAttributes().toStringWithSeparator(' '));
        }
        stringBuilder.append('>');
        if (this.hasValue()) {
            stringBuilder.append(this.getValue());
        }
        if (this.containsChildNodes()) {
            for (IMutableXmlNode c : this.getStoredChildNodes()) {
                stringBuilder.append(c.toString());
            }
        }
        stringBuilder.append("</").append(this.getName()).append('>');
        return stringBuilder.toString();
    }

    private void supposeHasValue() {
        if (!this.hasValue()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "value");
        }
    }
}

