/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNotNullException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.invalidargumentexception.EqualArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnequalArgumentException;
import ch.nolix.core.errorcontrol.validator.Mediator;
import java.util.Objects;
import java.util.function.Predicate;

public class ArgumentMediator<A>
extends Mediator {
    private final A argument;

    protected ArgumentMediator(A argument) {
        this("argument", argument);
    }

    protected ArgumentMediator(String argumentName, A argument) {
        super(argumentName);
        this.argument = argument;
    }

    public static <A2> ArgumentMediator<A2> forArgument(A2 argument) {
        return new ArgumentMediator<A2>(argument);
    }

    public final void fulfills(Predicate<A> condition) {
        if (condition == null) {
            throw ArgumentIsNullException.forArgumentName("condition");
        }
        if (!condition.test(this.getStoredArgument())) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "does not fulfil the given condition");
        }
    }

    public final void hasSameStringRepresentationAs(Object object) {
        if (object == null) {
            throw ArgumentIsNullException.forArgumentType(Object.class);
        }
        String stringRepresentation = object.toString();
        this.hasStringRepresentation(stringRepresentation);
    }

    public final void hasStringRepresentation(String stringRepresentation) {
        this.isNotNull();
        String actualStringRepresentation = this.getStoredArgument().toString();
        if (!Objects.equals(actualStringRepresentation, stringRepresentation)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "does not have the String representation '" + stringRepresentation + "'");
        }
    }

    public final void isEqualTo(Object object) {
        if (!Objects.equals(this.getStoredArgument(), object)) {
            throw UnequalArgumentException.forArgumentAndValue(this.argument, object);
        }
    }

    public final void is(Object object) {
        if (this.argument != object) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is not the given object");
        }
    }

    public final void isNot(Object object) {
        if (this.argument == object) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is the given object");
        }
    }

    public final void isNotEqualTo(A object) {
        if (Objects.equals(this.getStoredArgument(), object)) {
            throw EqualArgumentException.forArgumentAndEqualValue(this.argument, object);
        }
    }

    public final void isNotNull() {
        if (this.argument == null) {
            throw ArgumentIsNullException.forArgumentName(this.getArgumentName());
        }
    }

    public final void isNull() {
        if (this.argument != null) {
            throw ArgumentIsNotNullException.forArgument(this.getStoredArgument());
        }
    }

    public final void isOfType(Class<?> type) {
        this.isNotNull();
        if (!type.isAssignableFrom(this.getStoredArgument().getClass())) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is not a " + String.valueOf(type));
        }
    }

    protected A getStoredArgument() {
        return this.argument;
    }
}

