/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsInRangeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsOutOfRangeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.BiggerArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.EqualArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidPortException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NegativeArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NonNegativeArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NonPositiveArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.PositiveArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.SmallerArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnequalArgumentException;
import ch.nolix.core.errorcontrol.validator.Mediator;
import ch.nolix.core.independent.arraytool.ArrayTool;

public class LongMediator
extends Mediator {
    private static final ArrayTool ARRAY_TOOL = new ArrayTool();
    private final long argument;

    protected LongMediator(long argument) {
        this.argument = argument;
    }

    private LongMediator(String argumentName, long argument) {
        super(argumentName);
        this.argument = argument;
    }

    public static LongMediator forArgument(long argument) {
        return new LongMediator(argument);
    }

    public static LongMediator forArgumentNameAndArgument(String argumentName, long argument) {
        return new LongMediator(argumentName, argument);
    }

    public final void isBetween(int min, int max) {
        this.isBetween((long)min, (long)max);
    }

    public final void isBetween(long min, long max) {
        if (this.argument < min || this.argument > max) {
            throw ArgumentIsOutOfRangeException.forArgumentAndArgumentNameAndRangeWithMinAndMax(this.argument, this.getArgumentName(), min, max);
        }
    }

    public final void isBiggerThan(long value) {
        if (this.argument <= value) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.argument, this.getArgumentName(), "is not bigger than " + value);
        }
    }

    public final void isBiggerThanOrEquals(long value) {
        if (this.argument < value) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.argument, this.getArgumentName(), "is not bigger than or equal to " + value);
        }
    }

    public final void isEqualTo(int value) {
        this.isEqualTo((long)value);
    }

    public final void isEqualTo(long value) {
        if (this.argument != value) {
            throw UnequalArgumentException.forArgumentAndArgumentNameAndValue(this.argument, this.getArgumentName(), value);
        }
    }

    public final void isEqualToAny(long value, long ... values) {
        if (this.argument == value) {
            return;
        }
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            if (this.argument == v) {
                return;
            }
            ++n2;
        }
        throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.argument, this.getArgumentName(), "does not equal one of {" + ARRAY_TOOL.createString(values) + "}");
    }

    public final void isNegative() {
        if (this.argument >= 0L) {
            throw NonNegativeArgumentException.forArgumentAndArgumentName(this.argument, this.getArgumentName());
        }
    }

    public final void isNotBetween(long min, long max) {
        if (this.argument >= min && this.argument <= max) {
            throw ArgumentIsInRangeException.forArgumentNameAndArgumentAndRangeWithMinAndMax(this.getArgumentName(), this.argument, min, max);
        }
    }

    public final void isNotEqualTo(long value) {
        if (this.argument == value) {
            throw EqualArgumentException.forArgumentAndArgumentNameAndEqualValue(this.argument, this.getArgumentName(), value);
        }
    }

    public final void isNotBiggerThan(int value) {
        this.isNotBiggerThan((long)value);
    }

    public final void isNotBiggerThan(long value) {
        if (this.argument > value) {
            throw BiggerArgumentException.forArgumentAndArgumentNameAndMax(this.argument, this.getArgumentName(), value);
        }
    }

    public final void isNotNegative() {
        if ((double)this.argument < 0.0) {
            throw NegativeArgumentException.forArgumentAndArgumentName(this.argument, this.getArgumentName());
        }
    }

    public final void isNotPositive() {
        if (this.argument > 0L) {
            throw PositiveArgumentException.forArgumentAndArgumentName(this.argument, this.getArgumentName());
        }
    }

    public final void isNotSmallerThan(int min) {
        if (this.getArgument() < (long)min) {
            throw SmallerArgumentException.forArgumentNameAndArgumentAndLimit(this.getArgument(), this.getArgumentName(), min);
        }
    }

    public final void isPort() {
        if (this.argument < 0L || this.argument > 65535L) {
            throw InvalidPortException.forPort(this.argument);
        }
    }

    public final void isPositive() {
        if (this.argument < 1L) {
            throw NonPositiveArgumentException.forArgumentAndArgumentName(this.argument, this.getArgumentName());
        }
    }

    public final void isSmallerThan(long value) {
        if (this.argument >= value) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.argument, this.getArgumentName(), "is not smaller than " + value);
        }
    }

    public final void isSmallerThanOrEquals(long value) {
        if (this.argument > value) {
            throw BiggerArgumentException.forArgumentAndArgumentNameAndMax(this.argument, this.getArgumentName(), value);
        }
    }

    protected final long getArgument() {
        return this.argument;
    }
}

