/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.independent.arraytool.ArrayTool;
import java.util.function.Predicate;

public class MultiArgumentMediator<A> {
    private static final ArrayTool ARRAY_TOOL = new ArrayTool();
    private final Iterable<A> arguments;

    MultiArgumentMediator(Iterable<A> arguments) {
        if (arguments == null) {
            throw ArgumentIsNullException.forArgumentName("arguments");
        }
        this.arguments = arguments;
    }

    MultiArgumentMediator(A[] arguments) {
        this(ARRAY_TOOL.createIterable(arguments));
    }

    public final void areNotNull() {
        int index = 1;
        for (A a : this.getStoredArguments()) {
            if (a == null) {
                throw ArgumentIsNullException.forArgumentName(index + "th argument");
            }
            ++index;
        }
    }

    public final void fulfill(Predicate<A> condition) {
        int index = 1;
        for (A a : this.getStoredArguments()) {
            if (!condition.test(a)) {
                throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(a, index + "th argument", "does not fulfil the given condition");
            }
            ++index;
        }
    }

    protected final Iterable<A> getStoredArguments() {
        return this.arguments;
    }
}

