/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.independent.list;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ImmutableListIterator<E>
implements Iterator<E> {
    private final E[] parentArray;
    private int nextIndex;

    private ImmutableListIterator(E[] parrentArray) {
        if (parrentArray == null) {
            throw new IllegalArgumentException("The given parent array is null.");
        }
        this.parentArray = parrentArray;
        this.nextIndex = 0;
    }

    public static <T> ImmutableListIterator<T> forArray(T[] array) {
        return new ImmutableListIterator<T>(array);
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.parentArray.length;
    }

    @Override
    public E next() {
        this.assertHasNext();
        return this.nextWhenHasNext();
    }

    private void assertHasNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The current ArrayIterator does not have a next element.");
        }
    }

    private E nextWhenHasNext() {
        E element = this.parentArray[this.nextIndex];
        ++this.nextIndex;
        return element;
    }
}

