/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.misc.dataobject;

import ch.nolix.core.errorcontrol.validator.Validator;

public final class UnsignedByte {
    private final int mByte;

    public UnsignedByte(byte pByte) {
        this.mByte = pByte & 0xFF;
    }

    public UnsignedByte(int bit1, int bit2, int bit3, int bit4, int bit5, int bit6, int bit7, int bit8) {
        this.mByte = 128 * bit1 + 64 * bit2 + 32 * bit3 + 16 * bit4 + 8 * bit5 + 4 * bit6 + 2 * bit7 + bit8;
    }

    public static UnsignedByte fromNumber(int number) {
        Validator.assertThat(number).thatIsNamed("number").isBetween(0, 255);
        return new UnsignedByte((byte)(number - 128));
    }

    public boolean getBitAt(int index) {
        return this.getBitAtAsInt(index) == 1;
    }

    public int getBitAtAsInt(int index) {
        Validator.assertThat(index).thatIsNamed("index").isBetween(1, 8);
        return this.mByte >> 8 - index & 1;
    }

    public String toBitString() {
        return String.format("%d%d%d%d%d%d%d%d", this.getBitAtAsInt(1), this.getBitAtAsInt(2), this.getBitAtAsInt(3), this.getBitAtAsInt(4), this.getBitAtAsInt(5), this.getBitAtAsInt(6), this.getBitAtAsInt(7), this.getBitAtAsInt(8));
    }

    public byte toByte() {
        return (byte)this.mByte;
    }

    public int toInt() {
        return this.mByte;
    }
}

