/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint2;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint2.AbstractEndPoint;
import ch.nolix.core.net.endpoint2.AbstractServer;
import ch.nolix.coreapi.net.endpoint2.ISlot;
import ch.nolix.coreapi.net.netproperty.ConnectionType;
import ch.nolix.coreapi.net.netproperty.PeerType;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;

public final class LocalEndPoint
extends AbstractEndPoint {
    private final PeerType peerType;
    private final LocalEndPoint counterpart;
    private final String target;

    public LocalEndPoint() {
        this.peerType = PeerType.FRONTEND;
        this.counterpart = new LocalEndPoint(this);
        this.target = null;
    }

    public LocalEndPoint(ISlot target) {
        this.peerType = PeerType.FRONTEND;
        this.counterpart = new LocalEndPoint(this, target.getName());
        this.target = null;
        target.takeBackendEndPoint(this.getStoredCounterpart());
    }

    public LocalEndPoint(AbstractServer abstractServer, String target) {
        this.peerType = PeerType.FRONTEND;
        this.counterpart = new LocalEndPoint(this, target);
        this.target = target;
        abstractServer.internalTakeBackendEndPoint(this.getStoredCounterpart());
    }

    private LocalEndPoint(LocalEndPoint counterPart) {
        this.peerType = PeerType.BACKEND;
        Validator.assertThat(counterPart).thatIsNamed("counterpart").isNotNull();
        this.counterpart = counterPart;
        this.target = null;
    }

    private LocalEndPoint(LocalEndPoint counterpart, String target) {
        this.peerType = PeerType.BACKEND;
        Validator.assertThat(counterpart).thatIsNamed("counterpart").isNotNull();
        this.counterpart = counterpart;
        Validator.assertThat(target).thatIsNamed("target").isNotEmpty();
        this.target = target;
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.LOCAL;
    }

    @Override
    public PeerType getPeerType() {
        return this.peerType;
    }

    public String sendAndWaitToReply(String message) {
        this.assertIsOpen();
        return this.getStoredCounterpart().receiveAndGetReply(message);
    }

    public LocalEndPoint getStoredCounterpart() {
        return this.counterpart;
    }

    @Override
    public String getCustomTargetSlot() {
        if (!this.hasCustomTargetSlot()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "target");
        }
        return this.target;
    }

    @Override
    public String getReplyForRequest(String message) {
        return this.getStoredCounterpart().receiveAndGetReply(message);
    }

    @Override
    public SecurityMode getSecurityMode() {
        return SecurityMode.NONE;
    }

    @Override
    public boolean hasCustomTargetSlot() {
        return this.target != null;
    }

    private String receiveAndGetReply(String message) {
        return this.getStoredReplier().apply(message);
    }
}

