/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.property.AbstractValue;
import java.util.function.Consumer;
import java.util.function.Function;

abstract class AbstractSingleValue<V>
extends AbstractValue<V> {
    private final Consumer<V> setterMethod;
    private V memberValue;

    protected AbstractSingleValue(String name, Consumer<V> setterMethod, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator) {
        super(name, valueCreator, specificationCreator);
        Validator.assertThat(setterMethod).thatIsNamed("setter method").isNotNull();
        this.setterMethod = setterMethod;
    }

    public final Node getSpecification() {
        return Node.withHeaderAndChildNodes(this.getName(), ((INode)this.specificationCreator.apply(this.getValue())).getStoredChildNodes());
    }

    public final V getValue() {
        if (this.memberValue == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndArgumentNameAndAttributeName(this, this.getName(), "value");
        }
        return this.memberValue;
    }

    @Override
    public final boolean isEmpty() {
        return this.memberValue == null;
    }

    public final void setValue(V value) {
        Validator.assertThat(value).thatIsNamed("value").isNotNull();
        if (!this.isMutable() && this.containsAny()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is not mutable and has already a value");
        }
        this.memberValue = value;
    }

    @Override
    protected final void addOrChangeValue(V value) {
        this.setterMethod.accept(value);
    }

    @Override
    public final void fillUpAttributesInto(ILinkedList<INode<?>> list) {
        if (this.containsAny()) {
            list.addAtEnd(this.getSpecification());
        }
    }

    protected final void internalClear() {
        this.memberValue = null;
    }
}

