/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.gui.colorgradient;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.systemapi.gui.box.Direction;
import ch.nolix.systemapi.gui.colorgradient.IColorGradient;

public final class ColorGradient
extends AbstractElement
implements IColorGradient {
    public static final Direction DEFAULT_DIRECTION = Direction.VERTICAL;
    public static final Color DEFAULT_COLOR1 = X11ColorCatalog.BLACK;
    public static final Color DEFAULT_COLOR2 = X11ColorCatalog.WHITE;
    private final Direction direction;
    private final Color color1;
    private final Color color2;

    private ColorGradient(Direction direction, Color color1, Color color2) {
        Validator.assertThat(direction).thatIsNamed("direction").isNotNull();
        Validator.assertThat(color1).thatIsNamed("color1").isNotNull();
        Validator.assertThat(color2).thatIsNamed("color2").isNotNull();
        this.direction = direction;
        this.color1 = color1;
        this.color2 = color2;
    }

    public static ColorGradient fromSpecification(INode<?> specification) {
        IContainer<?> attributes = specification.getStoredChildNodes();
        int attributeCount = attributes.getCount();
        return switch (attributeCount) {
            case 2 -> ColorGradient.from2Attributes(attributes);
            case 3 -> ColorGradient.from3Attributes(attributes);
            default -> throw InvalidArgumentException.forArgumentAndArgumentName(specification, "specification");
        };
    }

    public static ColorGradient withColors(Color color1, Color color2) {
        return new ColorGradient(DEFAULT_DIRECTION, color1, color2);
    }

    public static ColorGradient withDirectionAndColors(Direction direction, Color color1, Color color2) {
        return new ColorGradient(direction, color1, color2);
    }

    private static ColorGradient from2Attributes(IContainer<? extends INode<?>> attributes) {
        Node color1Specification = Node.withChildNode((INode)attributes.getStoredAtOneBasedIndex(1), new INode[0]);
        Node color2Specification = Node.withChildNode((INode)attributes.getStoredAtOneBasedIndex(2), new INode[0]);
        return ColorGradient.withColors(Color.fromSpecification(color1Specification), Color.fromSpecification(color2Specification));
    }

    private static ColorGradient from3Attributes(IContainer<? extends INode<?>> attributes) {
        Node directionSpecification = Node.withChildNode((INode)attributes.getStoredAtOneBasedIndex(1), new INode[0]);
        Node color1Specification = Node.withChildNode((INode)attributes.getStoredAtOneBasedIndex(2), new INode[0]);
        Node color2Specification = Node.withChildNode((INode)attributes.getStoredAtOneBasedIndex(3), new INode[0]);
        return new ColorGradient(Direction.fromSpecification(directionSpecification), Color.fromSpecification(color1Specification), Color.fromSpecification(color2Specification));
    }

    @Override
    public IContainer<INode<?>> getAttributes() {
        return LinkedList.withElement(Node.withHeader(this.getDirection().toString()), Node.withHeader(this.getColor1().toHexadecimalString()), Node.withHeader(this.getColor2().toHexadecimalString()));
    }

    @Override
    public Color getColor1() {
        return this.color1;
    }

    @Override
    public Color getColor2() {
        return this.color2;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }
}

