/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.middata.adapter;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.resourcecontrol.closecontroller.GroupCloseable;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.systemapi.middata.adapter.IDataAdapter;
import ch.nolix.systemapi.middata.adapter.IDataReader;
import ch.nolix.systemapi.middata.adapter.IDataWriter;
import ch.nolix.systemapi.middata.model.EntityCreationDto;
import ch.nolix.systemapi.middata.model.EntityDeletionDto;
import ch.nolix.systemapi.middata.model.EntityLoadingDto;
import ch.nolix.systemapi.middata.model.EntityUpdateDto;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDeletionDto;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDto;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDeletionDto;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDto;
import ch.nolix.systemapi.middata.model.MultiValueEntryDto;
import ch.nolix.systemapi.midschema.structure.ColumnIdentification;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.time.moment.ITime;

public abstract class AbstractDataAdapter
implements IDataAdapter {
    private final ICloseController closeController = CloseController.forElement(this);
    private final IDataReader dataReader;
    private final IDataWriter dataWriter;

    protected AbstractDataAdapter(IDataReader dataReader, IDataWriter dataWriter) {
        Validator.assertThat(dataReader).thatIsNamed(IDataReader.class).isNotNull();
        Validator.assertThat(dataWriter).thatIsNamed(IDataWriter.class).isNotNull();
        this.dataReader = dataReader;
        this.dataWriter = dataWriter;
        this.createCloseDependencyTo(dataReader);
        if (dataReader != dataWriter) {
            this.createCloseDependencyTo(dataWriter);
        }
    }

    @Override
    public final void clearMultiReference(String tableName, String entityId, String multiReferenceColumnName) {
        this.dataWriter.clearMultiReference(tableName, entityId, multiReferenceColumnName);
    }

    @Override
    public final void clearMultiValue(String tableName, String entityId, String multiFieldColumn) {
        this.dataWriter.clearMultiValue(tableName, entityId, multiFieldColumn);
    }

    @Override
    public final void createCloseDependencyTo(GroupCloseable element) {
        IDataAdapter.super.createCloseDependencyTo(element);
    }

    @Override
    public final void deleteEntity(String tableName, EntityDeletionDto entity) {
        this.dataWriter.deleteEntity(tableName, entity);
    }

    @Override
    public final void deleteMultiBackReferenceEntry(MultiBackReferenceEntryDeletionDto multiBackReferenceEntry) {
        this.dataWriter.deleteMultiBackReferenceEntry(multiBackReferenceEntry);
    }

    @Override
    public final void deleteMultiReferenceEntry(MultiReferenceEntryDeletionDto multiReferenceEntry) {
        this.dataWriter.deleteMultiReferenceEntry(multiReferenceEntry);
    }

    @Override
    public final void deleteMultiValueEntry(MultiValueEntryDto multiValueEntry) {
        this.dataWriter.deleteMultiValueEntry(multiValueEntry);
    }

    @Override
    public final void expectSchemaTimestamp(ITime schemaTimestamp) {
        this.dataWriter.expectSchemaTimestamp(schemaTimestamp);
    }

    @Override
    public final void expectTableContainsEntity(String tableName, String entityId) {
        this.dataWriter.expectTableContainsEntity(tableName, entityId);
    }

    @Override
    public final String getDatabaseName() {
        return this.dataReader.getDatabaseName();
    }

    @Override
    public final int getEntityCount(String tableName) {
        return this.dataReader.getEntityCount(tableName);
    }

    @Override
    public final int getSaveCount() {
        return this.dataWriter.getSaveCount();
    }

    @Override
    public final ITime getSchemaTimestamp() {
        return this.dataReader.getSchemaTimestamp();
    }

    @Override
    public final ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public final boolean hasChanges() {
        return this.dataWriter.hasChanges();
    }

    @Override
    public final IContainer<EntityLoadingDto> loadEntities(String tableName) {
        return this.dataReader.loadEntities(tableName);
    }

    @Override
    public final EntityLoadingDto loadEntity(String tableName, String id) {
        return this.dataReader.loadEntity(tableName, id);
    }

    @Override
    public final void insertEntity(String tableName, EntityCreationDto newEntity) {
        this.dataWriter.insertEntity(tableName, newEntity);
    }

    @Override
    public final void insertMultiBackReferenceEntry(MultiBackReferenceEntryDto multiBackReferenceEntry) {
        this.dataWriter.insertMultiBackReferenceEntry(multiBackReferenceEntry);
    }

    @Override
    public void insertMultiReferenceEntry(MultiReferenceEntryDto multiReferenceEntry) {
        this.dataWriter.insertMultiReferenceEntry(multiReferenceEntry);
    }

    @Override
    public final void insertMultiValueEntry(MultiValueEntryDto multiValueEntry) {
        this.dataWriter.insertMultiValueEntry(multiValueEntry);
    }

    @Override
    public final IContainer<String> loadMultiBackReferenceBackReferencedEntityIds(String tableName, String entityId, String multiBackReferenceColumnName) {
        return this.dataReader.loadMultiBackReferenceBackReferencedEntityIds(tableName, entityId, multiBackReferenceColumnName);
    }

    @Override
    public IContainer<MultiBackReferenceEntryDto> loadMultiBackReferenceEntries(TableIdentification table, String entityId, ColumnIdentification multiBackReferenceColumn) {
        return this.dataReader.loadMultiBackReferenceEntries(table, entityId, multiBackReferenceColumn);
    }

    @Override
    public final IContainer<MultiReferenceEntryDto> loadMultiReferenceEntries(String tableName, String entityId, String multiReferenceColumnName) {
        return this.dataReader.loadMultiReferenceEntries(tableName, entityId, multiReferenceColumnName);
    }

    @Override
    public final IContainer<Object> loadMultiValueValues(String tableName, String entityId, String multiFieldColumnName) {
        return this.dataReader.loadMultiValueValues(tableName, entityId, multiFieldColumnName);
    }

    @Override
    public final void noteClose() {
    }

    @Override
    public final void reset() {
        this.dataWriter.reset();
    }

    @Override
    public final void saveChanges() {
        this.dataWriter.saveChanges();
    }

    @Override
    public final boolean tableContainsEntity(String tableName, String entityId) {
        return this.dataReader.tableContainsEntity(tableName, entityId);
    }

    @Override
    public final boolean tableContainsEntityWithValueAtColumn(String tableName, String columnName, String value) {
        return this.dataReader.tableContainsEntityWithValueAtColumn(tableName, columnName, value);
    }

    @Override
    public final boolean tableContainsEntityWithValueAtColumnIgnoringEntities(String tableName, String columnName, String value, IContainer<String> entitiesToIgnoreIds) {
        return this.dataReader.tableContainsEntityWithValueAtColumnIgnoringEntities(tableName, columnName, value, entitiesToIgnoreIds);
    }

    @Override
    public final void updateEntity(String tableName, EntityUpdateDto entityUpdate) {
        this.dataWriter.updateEntity(tableName, entityUpdate);
    }
}

