/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.midschema.databaseinitializer;

import ch.nolix.core.errorcontrol.generalexception.GeneralException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.time.moment.Time;
import ch.nolix.systemapi.midschema.databaseinitializer.DatabaseState;
import ch.nolix.systemapi.midschema.databaseinitializer.IDatabaseInitializer;
import ch.nolix.systemapi.time.moment.ITime;

public abstract class AbstractDatabaseInitializer
implements IDatabaseInitializer {
    @Override
    public final void initializeDatabaseIfNotInitialized() {
        DatabaseState databaseState = this.getDatabaseState();
        switch (databaseState) {
            case UNINITIALIZED: {
                this.initializeDatabase();
                break;
            }
            case INITIALIZED: {
                break;
            }
            case INVALID: {
                throw GeneralException.withErrorMessage("The database has a schema that does not suit.");
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)databaseState);
            }
        }
    }

    protected abstract void initializeDatabaseWithInitialSchemaTimestamp(ITime var1);

    private void initializeDatabase() {
        Time initialSchemaTimestamp = Time.ofNow();
        this.initializeDatabaseWithInitialSchemaTimestamp(initialSchemaTimestamp);
    }
}

