/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.fieldvalidator;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectdata.fieldexaminer.MultiValueFieldTool;
import ch.nolix.system.objectdata.fieldvalidator.FieldValidator;
import ch.nolix.systemapi.objectdata.fieldexaminer.IMultiValueFieldExaminer;
import ch.nolix.systemapi.objectdata.fieldvalidator.IMultiValueFieldValidator;
import ch.nolix.systemapi.objectdata.model.IMultiValueField;

public final class MultiValueFieldValidator
extends FieldValidator
implements IMultiValueFieldValidator {
    private static final IMultiValueFieldExaminer MULTI_VALUE_EXAMINER = new MultiValueFieldTool();

    @Override
    public <V> void assertCanAddValue(IMultiValueField<V> multiValueField, V value) {
        if (!MULTI_VALUE_EXAMINER.canAddValue(multiValueField, value)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(multiValueField, "cannot add the given value '" + String.valueOf(value) + "'");
        }
    }

    @Override
    public void assertCanBeCleared(IMultiValueField<?> multiValueField) {
        if (!MULTI_VALUE_EXAMINER.canBeCleared(multiValueField)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(multiValueField, "cannot be cleared");
        }
    }

    @Override
    public <V> void assertCanRemoveValue(IMultiValueField<V> multiValueField, V value) {
        if (!MULTI_VALUE_EXAMINER.canRemoveValue(multiValueField, value)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(multiValueField, "cannot remove the given value '" + String.valueOf(value) + "'");
        }
    }
}

