/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.Column;
import ch.nolix.system.objectdata.model.Table;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.objectdata.model.IColumn;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;

public final class ColumnMapper {
    private ColumnMapper() {
    }

    public static IColumn mapMidSchemaColumnDtoToColumn(ColumnDto midSchemaColumnDto, Table<IEntity> parentTable, IContainer<? extends ITable<IEntity>> tables) {
        String id = midSchemaColumnDto.id();
        String name = midSchemaColumnDto.name();
        FieldType fieldType = midSchemaColumnDto.fieldType();
        Class<?> dataTypeClass = midSchemaColumnDto.dataType().getDataTypeClass();
        IContainer<String> referenceableTableIds = midSchemaColumnDto.referenceableTableIds();
        IContainer<ITable> referenceableTables = tables.getStoredSelected(t -> referenceableTableIds.containsAny(t::hasId));
        IContainer columns = tables.toMultiples(ITable::getStoredColumns);
        IContainer<String> backReferenceableColumnIds = midSchemaColumnDto.backReferenceableColumnIds();
        IContainer<IColumn> backReferenceableColumns = columns.getStoredSelected(c -> backReferenceableColumnIds.contains(c.getId()));
        return Column.withParentTableAndIdAndNameAndFieldTypeAndDataTypeClassAndReferenceableTablesAndBackReferenceableColumns(parentTable, id, name, fieldType, dataTypeClass, referenceableTables, backReferenceableColumns);
    }
}

