/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectdata.entitytool.TableNameExtractor;
import ch.nolix.system.objectdata.fieldexaminer.FieldExaminer;
import ch.nolix.system.objectdata.fieldexaminer.MultiReferenceExaminer;
import ch.nolix.system.objectdata.fieldvalidator.MultiReferenceValidator;
import ch.nolix.system.objectdata.model.AbstractBaseReference;
import ch.nolix.system.objectdata.model.BaseReferenceUpdater;
import ch.nolix.system.objectdata.model.MultiReferenceEntry;
import ch.nolix.systemapi.databaseobject.modelexaminer.IDatabaseObjectExaminer;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.entitytool.ITableNameExtractor;
import ch.nolix.systemapi.objectdata.fieldexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.fieldexaminer.IMultiReferenceExaminer;
import ch.nolix.systemapi.objectdata.fieldvalidator.IMultiReferenceValidator;
import ch.nolix.systemapi.objectdata.model.IBaseBackReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiReference;
import ch.nolix.systemapi.objectdata.model.IMultiReferenceEntry;
import ch.nolix.systemapi.objectdata.model.ITable;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;

public final class MultiReference<E extends IEntity>
extends AbstractBaseReference<E>
implements IMultiReference<E> {
    private static final IDatabaseObjectExaminer DATABASE_OBJECT_EXAMINER = new DatabaseObjectExaminer();
    private static final ITableNameExtractor TABLE_NAME_EXTRACTOR = new TableNameExtractor();
    private static final IMultiReferenceExaminer MULTI_REFERENCE_TOOL = new MultiReferenceExaminer();
    private static final IMultiReferenceValidator MULTI_REFERENCE_VALIDATOR = new MultiReferenceValidator();
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private boolean loadedAllPersistedReferencedEntityIds;
    private final LinkedList<MultiReferenceEntry<E>> localEntries = LinkedList.createEmpty();

    private MultiReference(IContainer<String> referenceableTableNames) {
        super(referenceableTableNames);
    }

    @SafeVarargs
    public static <T extends IEntity> MultiReference<T> forEntityTypes(Class<? extends T> ... entityTypes) {
        ContainerView<Class<String>> entityTypesView = ContainerView.forArray(entityTypes);
        IContainer<String> referenceableTableNamesView = entityTypesView.getViewOf(TABLE_NAME_EXTRACTOR::getTableNameOfEntityType);
        return new MultiReference(referenceableTableNamesView);
    }

    public static <T extends IEntity> MultiReference<T> forEntityTypes(IContainer<Class<? extends T>> entityTypes) {
        IContainer<String> referenceableTableNamesView = entityTypes.getViewOf(TABLE_NAME_EXTRACTOR::getTableNameOfEntityType);
        return new MultiReference(referenceableTableNamesView);
    }

    public static <T extends IEntity> MultiReference<T> forReferenceableTableNames(IContainer<String> referenceableTableNames) {
        return new MultiReference(referenceableTableNames);
    }

    public static <T extends IEntity> MultiReference<T> forReferenceableTableNames(String ... referenceableTableNames) {
        ContainerView<String> referenceableTableNamesView = ContainerView.forArray(referenceableTableNames);
        return new MultiReference(referenceableTableNamesView);
    }

    @Override
    public void addEntity(Object entity) {
        this.addCastedEntity((IEntity)entity);
    }

    @Override
    public void clear() {
        this.getAllStoredReferencedEntities().forEach(this::removeEntity);
        this.setAsEditedAndRunPossibleUpdateAction();
    }

    @Override
    public IContainer<String> getAllReferencedEntityIds() {
        this.updateStateLoadingAllPersistedReferencedEntityIdsIfNotLoaded();
        return this.localEntries.getViewOfStoredSelected(MULTI_REFERENCE_TOOL::isNewOrLoadedOrEdited).to(IMultiReferenceEntry::getReferencedEntityId);
    }

    @Override
    public IContainer<E> getAllStoredReferencedEntities() {
        this.updateStateLoadingAllPersistedReferencedEntityIdsIfNotLoaded();
        return this.localEntries.getViewOfStoredSelected(MULTI_REFERENCE_TOOL::isNewOrLoadedOrEdited).to(IMultiReferenceEntry::getStoredReferencedEntity);
    }

    @Override
    public IContainer<IBaseBackReference> getStoredBaseBackReferencesWhoReferencesBackThis() {
        LinkedList<IBaseBackReference> abstractBackReferences = LinkedList.createEmpty();
        for (IEntity e : this.getAllStoredReferencedEntities()) {
            IContainer<? extends IField> fields = e.internalGetStoredFields();
            Optional<IField> abstractBackReferenceContainer = fields.getOptionalStoredFirst(f -> f.referencesBackField(this));
            if (!abstractBackReferenceContainer.isPresent()) continue;
            IBaseBackReference abstractBackReference = (IBaseBackReference)abstractBackReferenceContainer.get();
            abstractBackReferences.addAtEnd(abstractBackReference);
        }
        return abstractBackReferences;
    }

    @Override
    public IContainer<? extends IMultiReferenceEntry<E>> getStoredNewAndDeletedEntries() {
        return this.localEntries.getStoredSelected(DATABASE_OBJECT_EXAMINER::isNewOrDeleted);
    }

    @Override
    public FieldType getType() {
        return FieldType.MULTI_REFERENCE;
    }

    @Override
    public void internalSetNullableValue(Object nullableValue, String nullableAdditionalValue) {
    }

    @Override
    public boolean isEmpty() {
        return this.getAllReferencedEntityIds().isEmpty();
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return this.getAllStoredReferencedEntities().iterator();
    }

    @Override
    public boolean loadedAllPersistedReferencedEntityIds() {
        return this.loadedAllPersistedReferencedEntityIds;
    }

    @Override
    public boolean referencesEntity(IEntity entity) {
        if (entity == null) {
            return false;
        }
        return this.getAllReferencedEntityIds().containsEqualing(entity.getId());
    }

    @Override
    public boolean referencesUninsertedEntity() {
        return this.getAllStoredReferencedEntities().containsAny(e -> !e.belongsToTable());
    }

    @Override
    public void removeEntity(Object entity) {
        this.removeCastedEntity((IEntity)entity);
    }

    @Override
    public void removeFirstEntity(Predicate<E> selector) {
        Optional<E> entity = this.getAllStoredReferencedEntities().getOptionalStoredFirst(selector);
        entity.ifPresent(this::removeEntity);
    }

    @Override
    protected void noteInsertIntoDatabase() {
        if (this.containsAny()) {
            for (IEntity e : this.getAllStoredReferencedEntities()) {
                this.updateProbableBackReferenceForSetOrAddedEntity(e);
            }
        }
    }

    private void addCastedEntity(E entity) {
        this.assertCanAddEntity(entity);
        this.updateStateAddingEntity(entity);
        this.updatePotentialBaseBackReferenceOfEntityForAddEntity(entity);
        this.insertEntityIntoDatabaseIfPossible(entity);
        this.setAsEditedAndRunPossibleUpdateAction();
    }

    private void assertCanAddEntity(E entity) {
        MULTI_REFERENCE_VALIDATOR.assertCanAddEntity(this, entity);
    }

    private void insertEntityIntoDatabaseIfPossible(E entity) {
        if (this.belongsToEntity() && this.getStoredParentEntity().belongsToTable() && entity.getState() == DatabaseObjectState.NEW && !entity.belongsToTable()) {
            this.getStoredParentEntity().getStoredParentDatabase().insertEntity(entity);
        }
    }

    private IContainer<MultiReferenceEntry<E>> loadAllPersistedReferencedEntityIds() {
        return this.getStoredDataAndSchemaAdapter().loadMultiReferenceEntries(this.getStoredParentEntity().getStoredParentTable().getName(), this.getStoredParentEntity().getId(), this.getName()).to(e -> MultiReferenceEntry.createLoadedEntryForMultiReferenceAndReferencedEntityIdAndReferencedTableId(this, e.referencedEntityId(), e.referencedEntityTableId()));
    }

    private boolean needsToLoadAllPersistedReferencedEntityIds() {
        return !this.loadedAllPersistedReferencedEntityIds() && FIELD_EXAMINER.belongsToLoadedEntity(this);
    }

    private void removeCastedEntity(E entity) {
        MULTI_REFERENCE_VALIDATOR.assertCanRemoveEntity(this, entity);
        this.updateStateLoadingAllPersistedReferencedEntityIdsIfNotLoaded();
        this.localEntries.getStoredFirst(le -> le.getReferencedEntityId().equals(entity.getId())).setDeleted();
        this.setAsEditedAndRunPossibleUpdateAction();
    }

    private void updatePotentialBaseBackReferenceOfEntityForAddEntity(E entity) {
        BaseReferenceUpdater.ofBaseReferenceUpdatePotentialBaseBackReferenceForAddOrSetEntity(this, entity);
    }

    private void updateStateAddingEntity(E entity) {
        MultiReferenceEntry<Object> multiReferenceEntry = entity.belongsToTable() ? MultiReferenceEntry.createNewEntryForMultiReferenceAndReferencedEntityIdAndReferencedTableId(this, entity.getId(), ((ITable)entity.getStoredParentTable()).getId()) : MultiReferenceEntry.createNewEntryForMultiReferenceAndReferencedEntity(this, entity);
        this.localEntries.addAtEnd(multiReferenceEntry);
    }

    private void updateStateLoadingAllPersistedReferencedEntityIds() {
        this.loadedAllPersistedReferencedEntityIds = true;
        this.localEntries.addAtEnd(this.loadAllPersistedReferencedEntityIds());
    }

    private void updateStateLoadingAllPersistedReferencedEntityIdsIfNotLoaded() {
        if (this.needsToLoadAllPersistedReferencedEntityIds()) {
            this.updateStateLoadingAllPersistedReferencedEntityIds();
        }
    }
}

