/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.entitytool.EntityCreator;
import ch.nolix.system.objectdata.schemamapper.ColumnMapper;
import ch.nolix.system.objectdata.schemamapper.TableMapper;
import ch.nolix.system.objectdata.schemasearcher.SchemaSearcher;
import ch.nolix.systemapi.midschema.fieldproperty.BaseFieldType;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IEntityTypeSet;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.schemamapper.IColumnMapper;
import ch.nolix.systemapi.objectdata.schemamapper.ITableMapper;
import ch.nolix.systemapi.objectdata.schemamodelsearcher.ISchemaSearcher;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.schemaadapter.ISchemaAdapter;

public final class SchemaInitializer {
    private static final ISchemaSearcher SCHEMA_SEARCHER = new SchemaSearcher();
    private static final ITableMapper TABLE_MAPPER = new TableMapper();
    private static final EntityCreator ENTITY_CREATOR = new EntityCreator();
    private static final IColumnMapper COLUMN_MAPPER = new ColumnMapper();

    public void initializeDatabaseFromSchemaUsingSchemaAdapterIfDatabaseIsEmpty(IEntityTypeSet entityTypeSet, ISchemaAdapter schemaAdapter) {
        if (schemaAdapter.databaseIsEmpty()) {
            this.initializeDatabaseToGivenSchemaUsingGivenSchemaAdapter(entityTypeSet, schemaAdapter);
        }
    }

    private void initializeDatabaseToGivenSchemaUsingGivenSchemaAdapter(IEntityTypeSet entityTypeSet, ISchemaAdapter schemaAdapter) {
        IContainer<ITable> tables = TABLE_MAPPER.mapSchemaToEmptyTables(entityTypeSet);
        tables.forEach(schemaAdapter::addTable);
        this.addBaseValueColumnsToTablesFromSchema(tables, entityTypeSet);
        this.addBaseReferenceColumnsToTablesFromSchema(tables, entityTypeSet, tables);
        this.addBaseBackReferenceColumnsToTablesFromSchema(tables, entityTypeSet, tables);
        schemaAdapter.saveChanges();
    }

    private void addBaseValueColumnsToTablesFromSchema(IContainer<ITable> tables, IEntityTypeSet entityTypeSet) {
        for (ITable t : tables) {
            Class<? extends IEntity> entityType = SCHEMA_SEARCHER.getEntityTypeByName(entityTypeSet, t.getName());
            this.addBaseValueColumnsToTableFromEntityType(t, entityType);
        }
    }

    private void addBaseValueColumnsToTableFromEntityType(ITable table, Class<? extends IEntity> entityType) {
        IEntity entity = ENTITY_CREATOR.createEmptyEntityForEntityType(entityType);
        IContainer<IField> baseValuesView = entity.internalGetStoredFields().getViewOfStoredSelected(p -> p.getType().getBaseType() == BaseFieldType.BASE_VALUE_FIELD);
        for (IField v : baseValuesView) {
            IColumn column = COLUMN_MAPPER.mapFieldToColumn(v, ImmutableList.createEmpty());
            table.addColumn(column);
        }
    }

    private void addBaseReferenceColumnsToTablesFromSchema(IContainer<ITable> tables, IEntityTypeSet entityTypeSet, IContainer<ITable> referencableTables) {
        for (ITable t : tables) {
            Class<? extends IEntity> entityType = SCHEMA_SEARCHER.getEntityTypeByName(entityTypeSet, t.getName());
            this.addBaseReferenceColumnsToTableFromEntityType(t, entityType, referencableTables);
        }
    }

    private void addBaseReferenceColumnsToTableFromEntityType(ITable table, Class<? extends IEntity> entityType, IContainer<ITable> referencableTables) {
        IEntity entity = ENTITY_CREATOR.createEmptyEntityForEntityType(entityType);
        IContainer<IField> baseReferencesView = entity.internalGetStoredFields().getViewOfStoredSelected(p -> p.getType().getBaseType() == BaseFieldType.BASE_REFERENCE);
        for (IField r : baseReferencesView) {
            IColumn column = COLUMN_MAPPER.mapFieldToColumn(r, referencableTables);
            table.addColumn(column);
        }
    }

    private void addBaseBackReferenceColumnsToTablesFromSchema(IContainer<ITable> tables, IEntityTypeSet entityTypeSet, IContainer<ITable> referencableTables) {
        for (ITable t : tables) {
            Class<? extends IEntity> entityType = SCHEMA_SEARCHER.getEntityTypeByName(entityTypeSet, t.getName());
            this.addBaseBackReferenceColumnsToTableFromEntityType(t, entityType, referencableTables);
        }
    }

    private void addBaseBackReferenceColumnsToTableFromEntityType(ITable table, Class<? extends IEntity> entityType, IContainer<ITable> referencableTables) {
        IEntity entity = ENTITY_CREATOR.createEmptyEntityForEntityType(entityType);
        IContainer<IField> baseBackReferencesView = entity.internalGetStoredFields().getViewOfStoredSelected(p -> p.getType().getBaseType() == BaseFieldType.BASE_BACK_REFERENCE);
        for (IField b : baseBackReferencesView) {
            IColumn column = COLUMN_MAPPER.mapFieldToColumn(b, referencableTables);
            table.addColumn(column);
        }
    }
}

