/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.persistence;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectdata.middatamodelmapper.MultiBackReferenceEntryDeletionDtoMapper;
import ch.nolix.system.objectdata.middatamodelmapper.MultiBackReferenceEntryDtoMapper;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDeletionDto;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDto;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IMultiBackReferenceEntryDeletionDtoMapper;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IMultiBackReferenceEntryDtoMapper;
import ch.nolix.systemapi.objectdata.model.IMultiBackReferenceEntry;
import ch.nolix.systemapi.objectdata.perstistence.IMultiBackReferenceEntrySaver;

public final class MultiBackReferenceEntrySaver
implements IMultiBackReferenceEntrySaver {
    private static final IMultiBackReferenceEntryDtoMapper MULTI_BACK_REFERENCE_ENTRY_DTO_MAPPER = new MultiBackReferenceEntryDtoMapper();
    private static final IMultiBackReferenceEntryDeletionDtoMapper MULTI_BACK_REFERENCE_ENTRY_DELETION_DTO_MAPPER = new MultiBackReferenceEntryDeletionDtoMapper();

    @Override
    public void saveMultiBackReferenceEntryChange(IMultiBackReferenceEntry<?> multiBackReferenceEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        DatabaseObjectState multiBackReferenceEntryState = (DatabaseObjectState)((Object)multiBackReferenceEntry.getState());
        switch (multiBackReferenceEntryState) {
            case NEW: {
                this.saveMultiBackReferenceEntryCreation(multiBackReferenceEntry, dataAndSchemaAdapter);
                break;
            }
            case DELETED: {
                this.saveMultiBackReferenceEntryDeletion(multiBackReferenceEntry, dataAndSchemaAdapter);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName((Object)multiBackReferenceEntryState, "state of multi back  reference entry");
            }
        }
    }

    @Override
    public void saveMultiBackReferenceEntryCreation(IMultiBackReferenceEntry<?> multiBackReferenceEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        MultiBackReferenceEntryDto multiBackReferenceEntryDto = MULTI_BACK_REFERENCE_ENTRY_DTO_MAPPER.mapMultiBackReferenceEntryToMultiBackReferenceEntryDto(multiBackReferenceEntry);
        dataAndSchemaAdapter.insertMultiBackReferenceEntry(multiBackReferenceEntryDto);
    }

    @Override
    public void saveMultiBackReferenceEntryDeletion(IMultiBackReferenceEntry<?> multiBackReferenceEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        MultiBackReferenceEntryDeletionDto multiBackReferenceEntryDeletionDto = MULTI_BACK_REFERENCE_ENTRY_DELETION_DTO_MAPPER.mapMultiBackReferenceEntryToMultiBackReferenceEntryDeletionDto(multiBackReferenceEntry);
        dataAndSchemaAdapter.deleteMultiBackReferenceEntry(multiBackReferenceEntryDeletionDto);
    }
}

