/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlschema.adapter;

import ch.nolix.core.container.arraylist.ArrayList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.core.resourcecontrol.resourcevalidator.ResourceValidator;
import ch.nolix.core.sql.sqltool.SqlCollector;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.IArrayList;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.system.sqlschema.statementcreator.StatementCreator;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.sqlschema.adapter.ISchemaWriter;
import ch.nolix.systemapi.sqlschema.model.ColumnDto;
import ch.nolix.systemapi.sqlschema.model.TableDto;
import ch.nolix.systemapi.sqlschema.statementcreator.IStatementCreator;

public final class SchemaWriter
implements ISchemaWriter {
    private static final IStatementCreator STATEMENT_CREATOR = new StatementCreator();
    private final ICloseController closeController = CloseController.forElement(this);
    private final ISqlConnection sqlConnection;
    private final SqlCollector sqlCollector = new SqlCollector();
    private final IArrayList<String> addiditionalSqlStatements = ArrayList.createEmpty();
    private int saveCount;

    private SchemaWriter(String databaseName, ISqlConnection sqlConnection) {
        Validator.assertThat(databaseName).thatIsNamed("database name").isNotBlank();
        ResourceValidator.assertIsOpen(sqlConnection);
        this.sqlConnection = sqlConnection;
        this.createCloseDependencyTo(sqlConnection);
        this.sqlCollector.addSqlStatement("USE " + databaseName, new String[0]);
    }

    public static SchemaWriter forDatabasNameAndSqlConnection(String databaseName, ISqlConnection sqlConnection) {
        return new SchemaWriter(databaseName, sqlConnection);
    }

    @Override
    public void addAdditionalSqlStatements(IContainer<String> additionalSqlStatements) {
        this.addiditionalSqlStatements.addAtEnd((Iterable<String>)additionalSqlStatements);
    }

    @Override
    public void addColumn(TableIdentification table, ColumnDto column) {
        String tableName = table.tableName();
        String statement = STATEMENT_CREATOR.createStatementToAddColumn(tableName, column);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    @Override
    public void addColumns(TableIdentification table, IContainer<ColumnDto> columns) {
        for (ColumnDto c : columns) {
            this.addColumn(table, c);
        }
    }

    @Override
    public void addTable(TableDto table) {
        String statement = STATEMENT_CREATOR.createStatementToAddTable(table);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    @Override
    public void addTables(IContainer<TableDto> tables) {
        for (TableDto t : tables) {
            this.addTable(t);
        }
    }

    @Override
    public void addTables(TableDto table, TableDto ... tables) {
        this.addTable(table);
        TableDto[] tableDtoArray = tables;
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            TableDto t = tableDtoArray[n2];
            this.addTable(t);
            ++n2;
        }
    }

    @Override
    public void deleteColumn(String tableName, String columnName) {
        String statement = STATEMENT_CREATOR.createStatementToDeleteColumn(tableName, columnName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    @Override
    public void deleteColumnIfExists(String tableName, String columnName) {
        String statement = STATEMENT_CREATOR.createStatementToDeleteColumnIfExists(tableName, columnName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    @Override
    public void deleteTable(String tableName) {
        String statement = STATEMENT_CREATOR.createStatementToDeleteTable(tableName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public int getSaveCount() {
        return this.saveCount;
    }

    @Override
    public boolean hasChanges() {
        return this.sqlCollector.containsAny();
    }

    @Override
    public void noteClose() {
    }

    @Override
    public void renameColumn(String tableName, String columnName, String newColumnName) {
        String statement = STATEMENT_CREATOR.createStatementToRenameColumn(tableName, columnName, newColumnName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    @Override
    public void renameColumnIfExists(String tableName, String columnName, String newColumnName) {
        String statement = STATEMENT_CREATOR.createStatementToRenameColumnIfExists(tableName, columnName, newColumnName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    @Override
    public void renameTable(String tableName, String newTableName) {
        String statement = STATEMENT_CREATOR.createStatementToRenameTable(tableName, newTableName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    @Override
    public void reset() {
        this.sqlCollector.clear();
        this.addiditionalSqlStatements.clear();
    }

    @Override
    public void saveChanges() {
        try {
            this.sqlCollector.addSqlStatements(this.addiditionalSqlStatements);
            this.sqlCollector.executeAndClearUsingConnection(this.sqlConnection);
            ++this.saveCount;
        }
        finally {
            this.reset();
        }
    }
}

