/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.style.model.AbstractStyle;
import ch.nolix.systemapi.style.model.ISelectingStyleWithSelectors;
import ch.nolix.systemapi.style.stylable.IStylableElement;

public abstract class AbstractSelectingStyle
extends AbstractStyle<ISelectingStyleWithSelectors>
implements ISelectingStyleWithSelectors {
    protected static final String SELECTOR_ID_HEADER = "SelectorId";
    protected static final String SELECTOR_TYPE_HEADER = "SelectorType";
    protected static final String SELECTOR_ROLE_HEADER = "SelectorRole";
    protected static final String SELECTOR_TOKEN_HEADER = "SelectorToken";
    private final String memberSelectorId;
    private final String memberSelectorType;
    private final ImmutableList<String> memberSelectorRoles;
    private final ImmutableList<String> memberSelectorTokens;

    protected AbstractSelectingStyle(String optionalSelectorId, String optionalSelectorType, IContainer<String> selectorRoles, IContainer<String> selectorTokens, IContainer<String> attachingAttributes, IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        super(attachingAttributes, subStyles);
        Validator.assertThatTheStrings(selectorRoles).areNotBlank();
        Validator.assertThatTheStrings(selectorTokens).areNotBlank();
        this.memberSelectorId = optionalSelectorId;
        this.memberSelectorType = optionalSelectorType;
        this.memberSelectorRoles = ImmutableList.fromIterable(selectorRoles);
        this.memberSelectorTokens = ImmutableList.fromIterable(selectorTokens);
    }

    public final boolean containsSelectorRole(String selectorRole) {
        return this.memberSelectorRoles.containsEqualing(selectorRole);
    }

    public final boolean containsSelectorRoles() {
        return this.memberSelectorRoles.containsAny();
    }

    public final boolean containsSelectorToken(String selectorToken) {
        return this.memberSelectorTokens.containsEqualing(selectorToken);
    }

    public final boolean containsSelectorTokens() {
        return this.memberSelectorTokens.containsAny();
    }

    @Override
    public final IContainer<INode<?>> getAttributes() {
        LinkedList<INode<?>> attributes = LinkedList.createEmpty();
        if (this.hasSelectorId()) {
            attributes.addAtEnd(Node.withHeaderAndChildNode(SELECTOR_ID_HEADER, this.getSelectorId(), new String[0]));
        }
        if (this.hasSelectorType()) {
            attributes.addAtEnd(Node.withHeaderAndChildNode(SELECTOR_TYPE_HEADER, this.getSelectorType(), new String[0]));
        }
        for (String r : this.getSelectorRoles()) {
            attributes.addAtEnd(Node.withHeaderAndChildNode(SELECTOR_ROLE_HEADER, r, new String[0]));
        }
        for (String a : this.getAttachingAttributes()) {
            attributes.addAtEnd(Node.withHeaderAndChildNode("AttachingAttribute", Node.fromString(a), new INode[0]));
        }
        for (ISelectingStyleWithSelectors s : this.getSubStyles()) {
            attributes.addAtEnd(s.getSpecification());
        }
        return attributes;
    }

    @Override
    public final String getSelectorId() {
        this.assertHasSelectorId();
        return this.memberSelectorId;
    }

    @Override
    public final IContainer<String> getSelectorRoles() {
        return this.memberSelectorRoles;
    }

    @Override
    public final IContainer<String> getSelectorTokens() {
        return this.memberSelectorTokens;
    }

    @Override
    public final String getSelectorType() {
        this.assertHasSelectorType();
        return this.memberSelectorType;
    }

    @Override
    public final boolean hasSelectorId() {
        return this.memberSelectorId != null;
    }

    public final boolean hasSelectorId(String selectorId) {
        if (!this.hasSelectorId()) {
            return false;
        }
        return this.getSelectorId().equals(selectorId);
    }

    @Override
    public final boolean hasSelectorType() {
        return this.memberSelectorType != null;
    }

    public final boolean hasSelectorType(Class<?> selectorType) {
        return selectorType != null && this.hasSelectorType(selectorType.getSimpleName());
    }

    public final boolean hasSelectorType(String selectorType) {
        if (!this.hasSelectorType()) {
            return false;
        }
        return this.getSelectorType().equals(selectorType);
    }

    @Override
    public final boolean selectsElement(IStylableElement<?> element) {
        return this.selectorIdAllowsToSelectElement(element) && this.selectorTypeAllowsToSelectElement(element) && this.selectorRolesAllowToSelectElement(element) && this.selectorTokensAllowToSelectElement(element);
    }

    @Override
    public final ISelectingStyleWithSelectors withSelectorRole(Enum<?> selectorRole, Enum<?> ... selectorRoles) {
        IContainer<String> allSelectorRolesView = ContainerView.forElementAndArray(selectorRole, selectorRoles).getViewOf(Object::toString);
        return this.withSelectorRoles(allSelectorRolesView);
    }

    @Override
    public final ISelectingStyleWithSelectors withSelectorRole(String selectorRole, String ... selectorRoles) {
        ContainerView<String> allSelectorRoles = ContainerView.forElementAndArray(selectorRole, selectorRoles);
        return this.withSelectorRoles(allSelectorRoles);
    }

    @Override
    public final ISelectingStyleWithSelectors withSelectorToken(String selectorToken, String ... selectorTokens) {
        ContainerView<String> allSelectorTokens = ContainerView.forElementAndArray(selectorToken, selectorTokens);
        return this.withSelectorTokens(allSelectorTokens);
    }

    @Override
    public final ISelectingStyleWithSelectors withSelectorType(Class<?> selectorType) {
        return this.withSelectorType(selectorType.getSimpleName());
    }

    private void assertHasSelectorId() {
        if (!this.hasSelectorId()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "selector id");
        }
    }

    private void assertHasSelectorType() {
        if (!this.hasSelectorType()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "selector type");
        }
    }

    private boolean selectorIdAllowsToSelectElement(IStylableElement<?> element) {
        return !this.hasSelectorId() || element.hasId(this.getSelectorId());
    }

    private boolean selectorRolesAllowToSelectElement(IStylableElement<?> element) {
        if (this.containsSelectorRoles()) {
            if (!this.getSelectorRoles().containsAny(element::hasRole)) {
                return false;
            }
        }
        return true;
    }

    private boolean selectorTokensAllowToSelectElement(IStylableElement<?> element) {
        return !this.containsSelectorTokens() || this.getSelectorTokens().containsAnyOf(element.getTokens());
    }

    private boolean selectorTypeAllowsToSelectElement(IStylableElement<?> element) {
        return !this.hasSelectorType() || element.isOfType(this.getSelectorType());
    }
}

