/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.counterpartupdater;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.system.webapplication.counterpartupdater.UpdateCommandCreator;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IWebGui;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public final class WebClientPartialCounterpartUpdater {
    private static final UpdateCommandCreator UPDATE_COMMAND_CREATOR = new UpdateCommandCreator();
    private final BooleanSupplier openStateRequestable;
    private final Consumer<IContainer<? extends IChainedNode>> counterpartRunner;

    private WebClientPartialCounterpartUpdater(Consumer<IContainer<? extends IChainedNode>> counterpartRunner, BooleanSupplier openStateRequestable) {
        Validator.assertThat(openStateRequestable).thatIsNamed("open state requestable").isNotNull();
        Validator.assertThat(counterpartRunner).thatIsNamed("counterpart runner").isNotNull();
        this.openStateRequestable = openStateRequestable;
        this.counterpartRunner = counterpartRunner;
    }

    public static WebClientPartialCounterpartUpdater forCounterpartRunnerAndOpenStateRequestable(Consumer<IContainer<? extends IChainedNode>> counterpartRunner, BooleanSupplier openStateRequester) {
        return new WebClientPartialCounterpartUpdater(counterpartRunner, openStateRequester);
    }

    public void updateControlOnCounterpart(IControl<?, ?> control, boolean updateConstellationOrStyle) {
        ImmutableList<IControl<?, ?>> controls = ImmutableList.withElements(control);
        this.updateControlsOnCounterpart(controls, updateConstellationOrStyle);
    }

    public void updateControlsOnCounterpart(IContainer<IControl<?, ?>> controls, boolean updateConstellationOrStyle) {
        Validator.assertThat(controls).thatIsNamed("controls").isNotEmpty();
        if (updateConstellationOrStyle) {
            IWebGui<?> webGui = ((IControl)controls.getStoredFirst()).getStoredParentGui();
            webGui.applyStyleIfHasStyle();
        }
        IContainer<IChainedNode> updateCommands = this.createUpdateCommandsForControls(controls, updateConstellationOrStyle);
        if (this.openStateRequestable.getAsBoolean()) {
            this.counterpartRunner.accept(updateCommands);
        }
    }

    private IContainer<IChainedNode> createUpdateCommandsForControls(IContainer<IControl<?, ?>> controls, boolean updateConstellationOrStyle) {
        Validator.assertThat(controls).thatIsNamed("controls").isNotEmpty();
        IWebGui<?> webGui = ((IControl)controls.getStoredFirst()).getStoredParentGui();
        LinkedList<IChainedNode> updatedCommands = LinkedList.createEmpty();
        updatedCommands.addAtEnd(controls.getViewOf(UPDATE_COMMAND_CREATOR::createSetRootHtmlElementCommandFromControl));
        if (updateConstellationOrStyle) {
            updatedCommands.addAtEnd(UPDATE_COMMAND_CREATOR.createSetCssCommandFromWebGui(webGui), (IChainedNode[])new IChainedNode[]{UPDATE_COMMAND_CREATOR.createSetEventFunctionsCommandFromWebGui(webGui), UPDATE_COMMAND_CREATOR.createSetUserInputFunctionsCommandFromWebGui(webGui)});
        }
        return updatedCommands;
    }
}

