/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webatomiccontrol.imagecontrol;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.web.htmlelementmodel.HtmlAttribute;
import ch.nolix.core.web.htmlelementmodel.HtmlElement;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlAttribute;
import ch.nolix.systemapi.webatomiccontrol.imagecontrol.IImageControl;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;

public final class ImageControlHtmlBuilder
implements IControlHtmlBuilder<IImageControl> {
    public HtmlElement createHtmlElementForControl(IImageControl imageControl) {
        return HtmlElement.withTypeAndAttributes("img", this.createHtmlAttributesFromImageControl(imageControl));
    }

    private IContainer<IHtmlAttribute> createHtmlAttributesFromImageControl(IImageControl imageControl) {
        LinkedList<IHtmlAttribute> htmlAttributes = LinkedList.createEmpty();
        if (imageControl.containsAny()) {
            HtmlAttribute srcAttribute = HtmlAttribute.withNameAndValue("src", "data:image/jpeg;base64," + imageControl.getStoredImage().toBase64Jpg());
            htmlAttributes.addAtEnd(srcAttribute);
        }
        HtmlAttribute altAttribute = HtmlAttribute.withNameAndValue("alt", imageControl.getAlternateText());
        htmlAttributes.addAtEnd(altAttribute);
        return htmlAttributes;
    }
}

