/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webatomiccontrol.itemmenu;

import ch.nolix.core.datamodel.id.IdCreator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.mutableelement.AbstractMutableElement;
import ch.nolix.system.element.property.MutableValue;
import ch.nolix.system.element.property.OptionalValue;
import ch.nolix.system.element.property.Value;
import ch.nolix.systemapi.gui.selection.Selectable;
import ch.nolix.systemapi.webatomiccontrol.itemmenu.IItemMenu;
import ch.nolix.systemapi.webatomiccontrol.itemmenu.IItemMenuItem;
import java.util.function.Consumer;

public final class ItemMenuItem
extends AbstractMutableElement
implements IItemMenuItem<ItemMenuItem> {
    public static final boolean DEFAULT_SELECTION_FLAG = false;
    private static final String ID_HEADER = "Id";
    private static final String TEXT_HEADER = "Text";
    private static final String SELECTION_FLAG_HEADER = "Selected";
    private IItemMenu<?, ?> nullableParentMenu;
    private final OptionalValue<String> id = OptionalValue.forString("Id", this::setId);
    private final Value<String> text = Value.forString("Text", this::setText);
    private final MutableValue<Boolean> selectionFlag = MutableValue.forBoolean("Selected", false, this::setSelectionFlag);
    private final Consumer<IItemMenuItem<?>> nullableSelectAction;

    private ItemMenuItem() {
        this.nullableSelectAction = null;
    }

    private ItemMenuItem(Consumer<IItemMenuItem<?>> selectAction) {
        Validator.assertThat(selectAction).thatIsNamed("select action").isNotNull();
        this.nullableSelectAction = selectAction;
    }

    public static ItemMenuItem createBlankItem() {
        return ItemMenuItem.withText("");
    }

    public static ItemMenuItem fromSpecification(INode<?> specification) {
        ItemMenuItem item = new ItemMenuItem();
        item.resetFromSpecification(specification);
        return item;
    }

    public static ItemMenuItem withIdAndText(String id, String text) {
        ItemMenuItem item = new ItemMenuItem();
        item.setId(id);
        item.setText(text);
        return item;
    }

    public static ItemMenuItem withIdAndTextAndSelectAction(String id, String text, Runnable selectAction) {
        ItemMenuItem item = new ItemMenuItem(i -> selectAction.run());
        item.setId(id);
        item.setText(text);
        return item;
    }

    public static ItemMenuItem withIdAndTextAndSelectAction(String id, String text, Consumer<IItemMenuItem<?>> selectAction) {
        ItemMenuItem item = new ItemMenuItem(selectAction);
        item.setId(id);
        item.setText(text);
        return item;
    }

    public static ItemMenuItem withText(String text) {
        ItemMenuItem item = new ItemMenuItem();
        item.setId(IdCreator.createIdOf10HexadecimalCharacters());
        item.setText(text);
        return item;
    }

    public static ItemMenuItem withTextAndSelectAction(String text, Runnable selectAction) {
        ItemMenuItem item = new ItemMenuItem(i -> selectAction.run());
        item.setId(IdCreator.createIdOf10HexadecimalCharacters());
        item.setText(text);
        return item;
    }

    public static ItemMenuItem withTextAndSelectAction(String text, Consumer<IItemMenuItem<?>> selectAction) {
        ItemMenuItem item = new ItemMenuItem(selectAction);
        item.setId(IdCreator.createIdOf10HexadecimalCharacters());
        item.setText(text);
        return item;
    }

    @Override
    public boolean belongsToMenu() {
        return this.nullableParentMenu != null;
    }

    @Override
    public String getId() {
        return (String)this.id.getValue();
    }

    @Override
    public String getText() {
        return (String)this.text.getValue();
    }

    @Override
    public boolean isBlank() {
        return this.getText().isEmpty();
    }

    @Override
    public boolean isSelected() {
        return (Boolean)this.selectionFlag.getValue();
    }

    @Override
    public void reset() {
        this.unselect();
    }

    @Override
    public void select() {
        if (!this.isSelected()) {
            this.selectWhenNotSelected();
        }
    }

    @Override
    public void unselect() {
        this.selectionFlag.setValue(false);
    }

    @Override
    public void internalSetParentMenu(IItemMenu<?, ?> parentMenu) {
        Validator.assertThat(parentMenu).thatIsNamed("parent menu").isNotNull();
        this.nullableParentMenu = parentMenu;
    }

    private boolean hasSelectAction() {
        return this.nullableSelectAction != null;
    }

    private void runOptionalSelectAction() {
        if (this.hasSelectAction()) {
            this.nullableSelectAction.accept(this);
        }
    }

    private void selectWhenNotSelected() {
        this.unselectItemsOfOptionalParentMenu();
        this.selectionFlag.setValue(true);
        if (this.belongsToMenu()) {
            this.nullableParentMenu.internalRunOptionalSelectActionForItem(this);
        }
        this.runOptionalSelectAction();
    }

    private void setId(String id) {
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        this.id.setValue(id);
    }

    private void setSelectionFlag(boolean selected) {
        if (selected) {
            this.select();
        } else {
            this.unselect();
        }
    }

    private void setText(String text) {
        this.text.setValue(text);
    }

    private void unselectItemsOfOptionalParentMenu() {
        if (this.belongsToMenu()) {
            this.nullableParentMenu.getStoredItems().forEach(Selectable::unselect);
        }
    }
}

