/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webatomiccontrol.link;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.web.htmlelementmodel.HtmlAttribute;
import ch.nolix.core.web.htmlelementmodel.HtmlElement;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.htmlattribute.LinkTarget;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlAttribute;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;
import ch.nolix.systemapi.webatomiccontrol.link.ILink;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;

public final class LinkHtmlBuilder
implements IControlHtmlBuilder<ILink> {
    @Override
    public IHtmlElement createHtmlElementForControl(ILink control) {
        return HtmlElement.withTypeAndAttributesAndInnerText("a", this.createHtmlAttributesForControl(control), control.getDisplayText());
    }

    private IContainer<? extends IHtmlAttribute> createHtmlAttributesForControl(ILink control) {
        LinkedList htmlAttribtues = LinkedList.createEmpty();
        htmlAttribtues.addAtEnd(this.createTargetHtmlAttributeForControl(control));
        if (control.hasUrl()) {
            htmlAttribtues.addAtEnd(HtmlAttribute.withNameAndValue("href", control.getUrl()));
        }
        return htmlAttribtues;
    }

    private HtmlAttribute createTargetHtmlAttributeForControl(ILink control) {
        LinkTarget target = control.getTarget();
        return this.createTargetHtmlAttributeForTarget(target);
    }

    private HtmlAttribute createTargetHtmlAttributeForTarget(LinkTarget target) {
        return switch (target) {
            case LinkTarget.CURRENT_TAB -> HtmlAttribute.withNameAndValue("target", "_self");
            case LinkTarget.NEW_TAB -> HtmlAttribute.withNameAndValue("target", "_blank");
            default -> throw InvalidArgumentException.forArgumentAndArgumentName((Object)target, "target");
        };
    }
}

