/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.controlstyle;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.system.element.multistateconfiguration.ForwardingProperty;
import ch.nolix.system.element.multistateconfiguration.NonCascadingProperty;
import ch.nolix.system.element.relativevalue.AbsoluteOrRelativeInt;
import ch.nolix.system.element.relativevalue.AbsoluteOrRelativeIntValidator;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.gui.background.Background;
import ch.nolix.system.gui.box.CornerShadow;
import ch.nolix.system.webgui.controlstyle.AbstractControlBaseStyle;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.element.multistateconfiguration.IMultiStateConfiguration;
import ch.nolix.systemapi.element.relativevalue.IAbsoluteOrRelativeInt;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.gui.background.IBackground;
import ch.nolix.systemapi.gui.background.ImageApplication;
import ch.nolix.systemapi.gui.box.ICornerShadow;
import ch.nolix.systemapi.gui.colorgradient.IColorGradient;
import ch.nolix.systemapi.webgui.controlstyle.IControlStyle;
import ch.nolix.systemapi.webgui.main.ControlState;

public abstract class AbstractControlStyle<S extends IControlStyle<S> & IMultiStateConfiguration<S, ControlState>>
extends AbstractControlBaseStyle<S>
implements IControlStyle<S> {
    public static final int DEFAULT_CORNER_RADIUS = 0;
    public static final int DEFAULT_BORDER_THICKNESS = 0;
    public static final IColor DEFAULT_BORDER_COLOR = X11ColorCatalog.BLACK;
    public static final IBackground DEFAULT_BACKGROUND = Background.TRANSPARENT_BACKGROUND;
    public static final int DEFAULT_PADDING = 0;
    private static final String WIDTH_HEADER = "Width";
    private static final String HEIGHT_HEADER = "Height";
    private static final String CORNER_RADIUS_HEADER = "CornerRadius";
    private static final String LEFT_BORDER_THICKNESS_HEADER = "LeftBorderThickness";
    private static final String RIGHT_BORDER_THICKNESS_HEADER = "RightBorderThickness";
    private static final String TOP_BORDER_THICKNESS_HEADER = "TopBorderThickness";
    private static final String BOTTOM_BORDER_THICKNESS_HEADER = "BottomBorderThickness";
    private static final String LEFT_BORDER_COLOR_HEADER = "LeftBorderColor";
    private static final String RIGHT_BORDER_COLOR_HEADER = "RightBorderColor";
    private static final String TOP_BORDER_COLOR_HEADER = "TopBorderColor";
    private static final String BOTTOM_BORDER_COLOR_HEADER = "BottomBorderColor";
    private static final String BACKGROUND_HEADER = "Background";
    private static final String LEFT_PADDING_HEADER = "LeftPadding";
    private static final String RIGHT_PADDING_HEADER = "RightPadding";
    private static final String TOP_PADDING_HEADER = "TopPadding";
    private static final String BOTTOM_PADDING_HEADER = "BottomPadding";
    private static final String CORNER_SHADOWS_HEADER = "CornerShadows";
    private static final String BORDER_COLOR_HEADER = "BorderColor";
    private static final String BORDER_THICKNESS_HEADER = "BorderThickness";
    private static final String PADDING_HEADER = "Padding";
    private final NonCascadingProperty<ControlState, IAbsoluteOrRelativeInt> memberWidth = new NonCascadingProperty<ControlState, AbsoluteOrRelativeInt>("Width", ControlState.class, AbsoluteOrRelativeInt::fromSpecification, IElement::getSpecification, this::setWidthForState, AbsoluteOrRelativeInt.withIntValue(100));
    private final NonCascadingProperty<ControlState, IAbsoluteOrRelativeInt> memberHeight = new NonCascadingProperty<ControlState, AbsoluteOrRelativeInt>("Height", ControlState.class, AbsoluteOrRelativeInt::fromSpecification, IElement::getSpecification, this::setHeightForState, AbsoluteOrRelativeInt.withIntValue(100));
    private final NonCascadingProperty<ControlState, Integer> memberCornerRadius = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("CornerRadius", ControlState.class, (controlState, n) -> this.forStateSetCornerRadius((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, Integer> memberLeftBorderThickness = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("LeftBorderThickness", ControlState.class, (controlState, n) -> this.forStateSetLeftBorderThickness((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, Integer> memberRightBorderThickness = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("RightBorderThickness", ControlState.class, (controlState, n) -> this.forStateSetRightBorderThickness((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, Integer> memberTopBorderThickness = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("TopBorderThickness", ControlState.class, (controlState, n) -> this.forStateSetTopBorderThickness((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, Integer> memberBottomBorderThickness = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("BottomBorderThickness", ControlState.class, (controlState, n) -> this.forStateSetBottomBorderThickness((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, IColor> memberLeftBorderColor = new NonCascadingProperty<ControlState, IColor>("LeftBorderColor", ControlState.class, Color::fromSpecification, IElement::getSpecification, DEFAULT_BORDER_COLOR);
    private final NonCascadingProperty<ControlState, IColor> memberRightBorderColor = new NonCascadingProperty<ControlState, IColor>("RightBorderColor", ControlState.class, Color::fromSpecification, IElement::getSpecification, DEFAULT_BORDER_COLOR);
    private final NonCascadingProperty<ControlState, IColor> memberTopBorderColor = new NonCascadingProperty<ControlState, IColor>("TopBorderColor", ControlState.class, Color::fromSpecification, IElement::getSpecification, DEFAULT_BORDER_COLOR);
    private final NonCascadingProperty<ControlState, IColor> memberBottomBorderColor = new NonCascadingProperty<ControlState, IColor>("BottomBorderColor", ControlState.class, Color::fromSpecification, IElement::getSpecification, DEFAULT_BORDER_COLOR);
    private final NonCascadingProperty<ControlState, IBackground> memberBackground = new NonCascadingProperty<ControlState, IBackground>("Background", ControlState.class, Background::fromSpecification, IElement::getSpecification, DEFAULT_BACKGROUND);
    private final NonCascadingProperty<ControlState, IAbsoluteOrRelativeInt> memberLeftPadding = new NonCascadingProperty<ControlState, AbsoluteOrRelativeInt>("LeftPadding", ControlState.class, AbsoluteOrRelativeInt::fromSpecification, IElement::getSpecification, this::setLeftPaddingForState, AbsoluteOrRelativeInt.withIntValue(0));
    private final NonCascadingProperty<ControlState, IAbsoluteOrRelativeInt> memberRightPadding = new NonCascadingProperty<ControlState, AbsoluteOrRelativeInt>("RightPadding", ControlState.class, AbsoluteOrRelativeInt::fromSpecification, IElement::getSpecification, this::setRightPaddingForState, AbsoluteOrRelativeInt.withIntValue(0));
    private final NonCascadingProperty<ControlState, IAbsoluteOrRelativeInt> memberTopPadding = new NonCascadingProperty<ControlState, AbsoluteOrRelativeInt>("TopPadding", ControlState.class, AbsoluteOrRelativeInt::fromSpecification, IElement::getSpecification, this::setTopPaddingForState, AbsoluteOrRelativeInt.withIntValue(0));
    private final NonCascadingProperty<ControlState, IAbsoluteOrRelativeInt> memberBottomPadding = new NonCascadingProperty<ControlState, AbsoluteOrRelativeInt>("BottomPadding", ControlState.class, AbsoluteOrRelativeInt::fromSpecification, IElement::getSpecification, this::setBottomPaddingForState, AbsoluteOrRelativeInt.withIntValue(0));
    private final NonCascadingProperty<ControlState, IContainer<CornerShadow>> memberCornerShadows = new NonCascadingProperty("CornerShadows", ControlState.class, s -> s.getStoredChildNodes().to(CornerShadow::fromSpecification), s -> Node.withChildNodes(s.to(AbstractElement::getSpecification)), (controlState, iContainer) -> this.forStateSetCornerShadows((ControlState)((Object)controlState), (IContainer)iContainer), ImmutableList.createEmpty());
    private final ForwardingProperty<ControlState, Integer> memberBorderThickness = ForwardingProperty.withNameAndForProperty("BorderThickness", this.memberLeftBorderThickness, this.memberRightBorderThickness, this.memberTopBorderThickness, this.memberBottomBorderThickness);
    private final ForwardingProperty<ControlState, IColor> memberBorderColor = ForwardingProperty.withNameAndForProperty("BorderColor", this.memberLeftBorderColor, this.memberRightBorderColor, this.memberTopBorderColor, this.memberBottomBorderColor);
    private final ForwardingProperty<ControlState, IAbsoluteOrRelativeInt> memberPadding = ForwardingProperty.withNameAndForProperty("Padding", this.memberLeftPadding, this.memberRightPadding, this.memberTopPadding, this.memberBottomPadding);

    @Override
    public final boolean definesHeightForState(ControlState state) {
        return this.memberHeight.hasValueForState(state);
    }

    @Override
    public final boolean definesWidthForState(ControlState state) {
        return this.memberWidth.hasValueForState(state);
    }

    @Override
    public final IBackground getBackgroundWhenHasState(ControlState state) {
        return (IBackground)this.memberBackground.getValueWhenHasState(state);
    }

    @Override
    public final IColor getBottomBorderColorWhenHasState(ControlState state) {
        return (IColor)this.memberBottomBorderColor.getValueWhenHasState(state);
    }

    @Override
    public final int getBottomBorderThicknessWhenHasState(ControlState state) {
        return (Integer)this.memberBottomBorderThickness.getValueWhenHasState(state);
    }

    @Override
    public final IAbsoluteOrRelativeInt getBottomPaddingWhenHasState(ControlState state) {
        return (IAbsoluteOrRelativeInt)this.memberBottomPadding.getValueWhenHasState(state);
    }

    @Override
    public final int getCornerRadiusWhenHasState(ControlState state) {
        return (Integer)this.memberCornerRadius.getValueWhenHasState(state);
    }

    @Override
    public final IContainer<? extends ICornerShadow> getCornerShadowsWhenHasState(ControlState state) {
        return (IContainer)this.memberCornerShadows.getValueWhenHasState(state);
    }

    @Override
    public final IColor getLeftBorderColorWhenHasState(ControlState state) {
        return (IColor)this.memberLeftBorderColor.getValueWhenHasState(state);
    }

    @Override
    public final int getLeftBorderThicknessWhenHasState(ControlState state) {
        return (Integer)this.memberLeftBorderThickness.getValueWhenHasState(state);
    }

    @Override
    public final IAbsoluteOrRelativeInt getHeightForState(ControlState state) {
        return (IAbsoluteOrRelativeInt)this.memberHeight.getValueWhenHasState(state);
    }

    @Override
    public final IAbsoluteOrRelativeInt getLeftPaddingWhenHasState(ControlState state) {
        return (IAbsoluteOrRelativeInt)this.memberLeftPadding.getValueWhenHasState(state);
    }

    @Override
    public final IColor getRightBorderColorWhenHasState(ControlState state) {
        return (IColor)this.memberRightBorderColor.getValueWhenHasState(state);
    }

    @Override
    public final int getRightBorderThicknessWhenHasState(ControlState state) {
        return (Integer)this.memberRightBorderThickness.getValueWhenHasState(state);
    }

    @Override
    public final IAbsoluteOrRelativeInt getRightPaddingWhenHasState(ControlState state) {
        return (IAbsoluteOrRelativeInt)this.memberRightPadding.getValueWhenHasState(state);
    }

    @Override
    public final IColor getTopBorderColorWhenHasState(ControlState state) {
        return (IColor)this.memberTopBorderColor.getValueWhenHasState(state);
    }

    @Override
    public final int getTopBorderThicknessWhenHasState(ControlState state) {
        return (Integer)this.memberTopBorderThickness.getValueWhenHasState(state);
    }

    @Override
    public final IAbsoluteOrRelativeInt getTopPaddingWhenHasState(ControlState state) {
        return (IAbsoluteOrRelativeInt)this.memberTopPadding.getValueWhenHasState(state);
    }

    @Override
    public final IAbsoluteOrRelativeInt getWidthForState(ControlState state) {
        return (IAbsoluteOrRelativeInt)this.memberWidth.getValueWhenHasState(state);
    }

    @Override
    public final void removeCustomBackgrounds() {
        this.memberBackground.setUndefined();
    }

    @Override
    public final void removeCustomBorderColors() {
        this.memberBorderColor.setUndefined();
    }

    @Override
    public final void removeCustomBorderThicknesses() {
        this.removeCustomLeftBorderColors();
        this.removeCustomRightBorderColors();
        this.removeCustomTopBorderColors();
        this.removeCustomBottomBorderColors();
    }

    @Override
    public final void removeCustomBottomBorderColors() {
        this.memberBottomBorderColor.setUndefined();
    }

    @Override
    public final void removeCustomBottomBorderThicknesses() {
        this.memberBottomBorderThickness.setUndefined();
    }

    @Override
    public final void removeCustomBottomPaddings() {
        this.memberBottomPadding.setUndefined();
    }

    @Override
    public final void removeCustomCornerRadiuses() {
        this.memberCornerRadius.setUndefined();
    }

    @Override
    public final void removeCustomCornerShadows() {
        this.memberCornerShadows.setUndefined();
    }

    @Override
    public final void removeCustomHeights() {
        this.memberHeight.setUndefined();
    }

    @Override
    public final void removeCustomLeftBorderColors() {
        this.memberLeftBorderColor.setUndefined();
    }

    @Override
    public final void removeCustomLeftBorderThicknesses() {
        this.memberLeftBorderThickness.setUndefined();
    }

    @Override
    public final void removeCustomLeftPaddings() {
        this.memberLeftPadding.setUndefined();
    }

    @Override
    public final void removeCustomPaddings() {
        this.removeCustomLeftPaddings();
        this.removeCustomRightPaddings();
        this.removeCustomTopPaddings();
        this.removeCustomBottomPaddings();
    }

    @Override
    public final void removeCustomRightBorderColors() {
        this.memberRightBorderColor.setUndefined();
    }

    @Override
    public final void removeCustomRightBorderThicknesses() {
        this.memberRightBorderThickness.setUndefined();
    }

    @Override
    public final void removeCustomRightPaddings() {
        this.memberRightPadding.setUndefined();
    }

    @Override
    public final void removeCustomTopBorderColors() {
        this.memberTopBorderColor.setUndefined();
    }

    @Override
    public final void removeCustomTopBorderThicknesses() {
        this.memberTopBorderThickness.setUndefined();
    }

    @Override
    public final void removeCustomTopPaddings() {
        this.memberTopPadding.setUndefined();
    }

    @Override
    public final void removeCustomWidths() {
        this.memberWidth.setUndefined();
    }

    @Override
    public final S forStateSetBackgroundColor(ControlState state, IColor backgroundColor) {
        return (S)this.forStateSetBackground(state, Background.withColor(backgroundColor));
    }

    @Override
    public final S forStateSetBackgroundColorGradient(ControlState state, IColorGradient backgroundColorGradient) {
        return (S)this.forStateSetBackground(state, Background.withColorGradient(backgroundColorGradient));
    }

    @Override
    public final S forStateSetBackground(ControlState state, IBackground background) {
        this.memberBackground.setValueForState(state, background);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetBackgroundImage(ControlState state, IImage backgroundImage, ImageApplication imageApplication) {
        return (S)this.forStateSetBackground(state, Background.withImageAndImageApplication(backgroundImage, imageApplication));
    }

    @Override
    public final S forStateSetBorderColor(ControlState state, IColor borderColor) {
        this.memberBorderColor.setValueForState(state, borderColor);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetBorderThickness(ControlState state, int borderThickness) {
        this.memberBorderThickness.setValueForState(state, borderThickness);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetBottomBorderColor(ControlState state, IColor bottomBorderColor) {
        this.memberBottomBorderColor.setValueForState(state, bottomBorderColor);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetBottomBorderThickness(ControlState state, int bottomBorderThickness) {
        Validator.assertThat(bottomBorderThickness).thatIsNamed("bottom border thickness").isNotNegative();
        this.memberBottomBorderThickness.setValueForState(state, bottomBorderThickness);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetBottomPadding(ControlState state, int bottomPadding) {
        Validator.assertThat(bottomPadding).thatIsNamed("bottom padding").isNotNegative();
        this.memberBottomPadding.setValueForState(state, AbsoluteOrRelativeInt.withIntValue(bottomPadding));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetCornerRadius(ControlState state, int cornerRadius) {
        Validator.assertThat(cornerRadius).thatIsNamed("corner radius").isNotNegative();
        this.memberCornerRadius.setValueForState(state, cornerRadius);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetCornerShadow(ControlState state, ICornerShadow cornerShadow, ICornerShadow ... cornerShadows) {
        ContainerView<ICornerShadow> allCornerShadows = ContainerView.forElementAndArray(cornerShadow, cornerShadows);
        return (S)this.forStateSetCornerShadows(state, allCornerShadows);
    }

    @Override
    public final S forStateSetCornerShadows(ControlState state, IContainer<? extends ICornerShadow> cornerShadows) {
        this.memberCornerShadows.setValueForState(state, cornerShadows.to(CornerShadow::fromCornerShadow));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetHeight(ControlState state, int height) {
        this.setHeightForState(state, AbsoluteOrRelativeInt.withIntValue(height));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetHeightInPercentOfViewArea(ControlState state, double heightInPercentOfViewAreaHeight) {
        this.setHeightForState(state, AbsoluteOrRelativeInt.withPercentage(heightInPercentOfViewAreaHeight));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetLeftBorderColor(ControlState state, IColor leftBorderColor) {
        this.memberLeftBorderColor.setValueForState(state, leftBorderColor);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetLeftBorderThickness(ControlState state, int leftBorderThickness) {
        Validator.assertThat(leftBorderThickness).thatIsNamed("left border thickness").isNotNegative();
        this.memberLeftBorderThickness.setValueForState(state, leftBorderThickness);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetLeftPadding(ControlState state, int leftPadding) {
        Validator.assertThat(leftPadding).thatIsNamed("left padding").isNotNegative();
        this.memberLeftPadding.setValueForState(state, AbsoluteOrRelativeInt.withIntValue(leftPadding));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetPadding(ControlState state, int padding) {
        this.memberPadding.setValueForState(state, AbsoluteOrRelativeInt.withIntValue(padding));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetRightBorderColor(ControlState state, IColor rightBorderColor) {
        this.memberRightBorderColor.setValueForState(state, rightBorderColor);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetRightBorderThickness(ControlState state, int rightBorderThickness) {
        Validator.assertThat(rightBorderThickness).thatIsNamed("right border thickness").isNotNegative();
        this.memberRightBorderThickness.setValueForState(state, rightBorderThickness);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetRightPadding(ControlState state, int rightPadding) {
        Validator.assertThat(rightPadding).thatIsNamed("right padding").isNotNegative();
        this.memberRightPadding.setValueForState(state, AbsoluteOrRelativeInt.withIntValue(rightPadding));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetTopBorderColor(ControlState state, IColor topBorderColor) {
        this.memberTopBorderColor.setValueForState(state, topBorderColor);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetTopBorderThickness(ControlState state, int topBorderThickness) {
        Validator.assertThat(topBorderThickness).thatIsNamed("top border thickness").isNotNegative();
        this.memberTopBorderThickness.setValueForState(state, topBorderThickness);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetTopPadding(ControlState state, int topPadding) {
        Validator.assertThat(topPadding).thatIsNamed("top padding").isNotNegative();
        this.memberTopPadding.setValueForState(state, AbsoluteOrRelativeInt.withIntValue(topPadding));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetWidth(ControlState state, int width) {
        this.setWidthForState(state, AbsoluteOrRelativeInt.withIntValue(width));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S forStateSetWidthInPercentOfViewAreaWidth(ControlState state, double widthInPercentOfViewAreaWidth) {
        this.setWidthForState(state, AbsoluteOrRelativeInt.withPercentage(widthInPercentOfViewAreaWidth));
        return (S)((IControlStyle)this.asConcrete());
    }

    private void setBottomPaddingForState(ControlState state, IAbsoluteOrRelativeInt bottomPadding) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(bottomPadding);
        this.memberBottomPadding.setValueForState(state, bottomPadding);
    }

    private void setHeightForState(ControlState state, IAbsoluteOrRelativeInt height) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(height);
        this.memberHeight.setValueForState(state, height);
    }

    private void setLeftPaddingForState(ControlState state, IAbsoluteOrRelativeInt leftPadding) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(leftPadding);
        this.memberLeftPadding.setValueForState(state, leftPadding);
    }

    private void setRightPaddingForState(ControlState state, IAbsoluteOrRelativeInt rightPadding) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(rightPadding);
        this.memberRightPadding.setValueForState(state, rightPadding);
    }

    private void setTopPaddingForState(ControlState state, IAbsoluteOrRelativeInt topPadding) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(topPadding);
        this.memberTopPadding.setValueForState(state, topPadding);
    }

    private void setWidthForState(ControlState state, IAbsoluteOrRelativeInt width) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(width);
        this.memberWidth.setValueForState(state, width);
    }
}

