/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.main;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.datamodel.id.IdCreator;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentBelongsToParentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotBelongToParentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.cssmodel.ICssRule;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlAttribute;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;
import ch.nolix.system.element.property.ExtensionElement;
import ch.nolix.system.element.property.MutableOptionalValue;
import ch.nolix.system.element.property.MutableValue;
import ch.nolix.system.element.relativevalue.AbsoluteOrRelativeInt;
import ch.nolix.system.element.relativevalue.AbsoluteOrRelativeIntValidator;
import ch.nolix.system.style.stylable.AbstractStylableElement;
import ch.nolix.system.webgui.main.ControlHelper;
import ch.nolix.system.webgui.main.ControlParent;
import ch.nolix.systemapi.element.relativevalue.IAbsoluteOrRelativeInt;
import ch.nolix.systemapi.gui.model.CursorIcon;
import ch.nolix.systemapi.gui.presence.Presence;
import ch.nolix.systemapi.style.stylable.IStylableElement;
import ch.nolix.systemapi.webgui.controlstyle.IControlStyle;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.ILayer;
import ch.nolix.systemapi.webgui.main.IWebGui;
import java.util.Optional;
import java.util.function.Consumer;

public abstract class Control<C extends IControl<C, S>, S extends IControlStyle<S>>
extends AbstractStylableElement<C>
implements IControl<C, S> {
    public static final Presence DEFAULT_PRESENCE = Presence.VISIBLE;
    public static final CursorIcon DEFAULT_CURSOR_ICON = CursorIcon.ARROW;
    private static final String PRESENCE_HEADER = "Presence";
    private static final String MIN_WIDTH_HEADER = "MinWidth";
    private static final String MIN_HEIGHT_HEADER = "MinHeight";
    private static final String MAX_WIDTH_HEADER = "MaxWidth";
    private static final String MAX_HEIGHT_HEADER = "MaxHeight";
    private static final String CURSOR_ICON_HEADER = "CursorIcon";
    private final String memberInternalId = "i" + IdCreator.createIdOf10HexadecimalCharacters();
    private final MutableValue<Presence> presence = new MutableValue<Presence>("Presence", DEFAULT_PRESENCE, this::setPresence, Presence::fromSpecification, Node::fromEnum);
    private final MutableOptionalValue<AbsoluteOrRelativeInt> minWidth = MutableOptionalValue.forElement("MinWidth", this::setMinWidth, AbsoluteOrRelativeInt::fromSpecification);
    private final MutableOptionalValue<AbsoluteOrRelativeInt> minHeight = MutableOptionalValue.forElement("MinHeight", this::setMinHeight, AbsoluteOrRelativeInt::fromSpecification);
    private final MutableOptionalValue<AbsoluteOrRelativeInt> maxWidth = MutableOptionalValue.forElement("MaxWidth", this::setMaxWidth, AbsoluteOrRelativeInt::fromSpecification);
    private final MutableOptionalValue<AbsoluteOrRelativeInt> maxHeight = MutableOptionalValue.forElement("MaxHeight", this::setMaxHeight, AbsoluteOrRelativeInt::fromSpecification);
    private final MutableValue<CursorIcon> cursorIcon = new MutableValue<CursorIcon>("CursorIcon", DEFAULT_CURSOR_ICON, this::setCursorIcon, CursorIcon::fromSpecification, Node::fromEnum);
    private final ExtensionElement<S> style = new ExtensionElement<S>(this.createStyle());
    private ControlParent parent;
    private Object linkedObject;

    @Override
    public final boolean belongsToControl() {
        return this.parent != null && this.parent.isControl();
    }

    @Override
    public final boolean belongsToGui() {
        return this.belongsToLayer() && this.getStoredParentLayer().belongsToGui();
    }

    @Override
    public final boolean belongsToLayer() {
        return this.parent != null && this.parent.belongsToLayer();
    }

    @Override
    public final C editStyle(Consumer<S> styleEditor) {
        styleEditor.accept(this.getStoredStyle());
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final IContainer<ICssRule> getCssRules() {
        return this.getCssBuilder().createCssRulesForControl((IControl)this.asConcrete());
    }

    @Override
    public final CursorIcon getCursorIcon() {
        return (CursorIcon)((Object)this.cursorIcon.getValue());
    }

    @Override
    public final IHtmlElement getHtml() {
        IHtmlElement html = this.getHtmlBuilder().createHtmlElementForControl((IControl)this.asConcrete());
        return html.withAttribute(ControlHelper.createIdHtmlAttributeForControl(this), new IHtmlAttribute[0]);
    }

    @Override
    public final String getInternalId() {
        return this.memberInternalId;
    }

    @Override
    public final IAbsoluteOrRelativeInt getMaxHeight() {
        return (IAbsoluteOrRelativeInt)this.maxHeight.getValue();
    }

    @Override
    public final IAbsoluteOrRelativeInt getMaxWidth() {
        return (IAbsoluteOrRelativeInt)this.maxWidth.getValue();
    }

    @Override
    public final IAbsoluteOrRelativeInt getMinHeight() {
        return (IAbsoluteOrRelativeInt)this.minHeight.getValue();
    }

    @Override
    public final IAbsoluteOrRelativeInt getMinWidth() {
        return (IAbsoluteOrRelativeInt)this.minWidth.getValue();
    }

    @Override
    public final Presence getPresence() {
        return (Presence)((Object)this.presence.getValue());
    }

    @Override
    public final Optional<IControl<?, ?>> getOptionalStoredChildControlByInternalId(String internalId) {
        return this.getStoredChildControls().getOptionalStoredFirst(cs -> cs.hasInternalId(internalId));
    }

    @Override
    public final IContainer<? extends IStylableElement<?>> getStoredChildStylableElements() {
        return this.getStoredChildControls();
    }

    @Override
    public IContainer<Object> getStoredLinkedObjects() {
        if (!this.isLinkedToAnObject()) {
            return ImmutableList.createEmpty();
        }
        return ImmutableList.withElements(this.linkedObject);
    }

    @Override
    public final IControl<?, ?> getStoredParentControl() {
        return this.getStoredParent().getStoredControl();
    }

    @Override
    public final IWebGui<?> getStoredParentGui() {
        return (IWebGui)this.getStoredParentLayer().getStoredParentGui();
    }

    @Override
    public final ILayer<?> getStoredParentLayer() {
        return this.getStoredParent().getStoredRootLayer();
    }

    @Override
    public final S getStoredStyle() {
        return (S)((IControlStyle)this.style.getExtensionElement());
    }

    @Override
    public boolean hasInternalId(String internalId) {
        return this.getInternalId().equals(internalId);
    }

    @Override
    public final boolean hasMaxHeight() {
        return this.maxHeight.containsAny();
    }

    @Override
    public final boolean hasMaxWidth() {
        return this.maxWidth.containsAny();
    }

    @Override
    public final boolean hasMinHeight() {
        return this.minHeight.containsAny();
    }

    @Override
    public final boolean hasMinWidth() {
        return this.minWidth.containsAny();
    }

    @Override
    public final void internalSetParentControl(IControl<?, ?> parentControl) {
        this.setParent(ControlParent.forControl(parentControl));
    }

    @Override
    public final void internalSetParentLayer(ILayer<?> parentLayer) {
        this.setParent(ControlParent.forLayer(parentLayer));
    }

    @Override
    public final boolean isCollapsed() {
        return this.getPresence() == Presence.COLLAPSED;
    }

    @Override
    public final boolean isInvisible() {
        return this.getPresence() == Presence.INVISIBLE;
    }

    @Override
    public boolean isLinkedTo(Object object) {
        return this.isLinkedToAnObject() && this.linkedObject == object;
    }

    @Override
    public final boolean isLinkedToAnObject() {
        return this.linkedObject != null;
    }

    @Override
    public final boolean isVisible() {
        return this.getPresence() == Presence.VISIBLE;
    }

    @Override
    public final void linkTo(Object object) {
        Validator.assertThat(object).thatIsNamed(Object.class).isNotNull();
        this.assertIsNotLinkedAnObject();
        this.linkedObject = object;
    }

    @Override
    public final void removeMaxHeight() {
        this.maxHeight.clear();
    }

    @Override
    public final void removeMaxWidth() {
        this.maxWidth.clear();
    }

    @Override
    public final void removeMinHeight() {
        this.minHeight.clear();
    }

    @Override
    public final void removeMinWidth() {
        this.minWidth.clear();
    }

    @Override
    public final C setCollapsed() {
        this.setPresence(Presence.COLLAPSED);
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setCursorIcon(CursorIcon cursorIcon) {
        this.cursorIcon.setValue(cursorIcon);
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setInvisible() {
        this.setPresence(Presence.INVISIBLE);
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setMaxHeight(int maxHeight) {
        this.setMaxHeight(AbsoluteOrRelativeInt.withIntValue(maxHeight));
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setMaxHeightInPercentOfViewAreaHeight(double maxHeightInPercentOfViewAreaHeight) {
        this.setMaxHeight(AbsoluteOrRelativeInt.withPercentage(maxHeightInPercentOfViewAreaHeight));
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setMaxWidth(int maxWidth) {
        this.setMaxWidth(AbsoluteOrRelativeInt.withIntValue(maxWidth));
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setMaxWidthInPercentOfViewAreaWidth(double maxWidthInPercentOfViewAreaWidth) {
        this.setMaxWidth(AbsoluteOrRelativeInt.withPercentage(maxWidthInPercentOfViewAreaWidth));
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setMinHeight(int minHeight) {
        this.setMinHeight(AbsoluteOrRelativeInt.withIntValue(minHeight));
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setMinHeightInPercentOfViewAreaHeight(double minHeightInPercentOfViewAreaHeight) {
        this.setMinHeight(AbsoluteOrRelativeInt.withPercentage(minHeightInPercentOfViewAreaHeight));
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setMinWidth(int minWidth) {
        this.setMinWidth(AbsoluteOrRelativeInt.withIntValue(minWidth));
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setMinWidthInPercentOfViewAreaWidth(double minWidthInPercentOfViewAreaWidth) {
        this.setMinWidth(AbsoluteOrRelativeInt.withPercentage(minWidthInPercentOfViewAreaWidth));
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setVisible() {
        this.setPresence(Presence.VISIBLE);
        return (C)((IControl)this.asConcrete());
    }

    @Override
    public final C setVisibility(boolean visible) {
        this.voidSetVisibility(visible);
        return (C)((IControl)this.asConcrete());
    }

    protected abstract S createStyle();

    protected abstract IControlCssBuilder<C, S> getCssBuilder();

    protected abstract IControlHtmlBuilder<C> getHtmlBuilder();

    protected abstract void resetControl();

    @Override
    protected final void resetStylableElement() {
        this.setVisible();
        this.removeMinWidth();
        this.removeMinHeight();
        this.removeMaxWidth();
        this.removeMaxHeight();
        this.setCursorIcon(DEFAULT_CURSOR_ICON);
        this.resetControl();
    }

    @Override
    protected final void resetStyle() {
        this.getStoredStyle().reset();
    }

    private void assertBelongsToParent() {
        if (!this.belongsToParent()) {
            throw ArgumentDoesNotBelongToParentException.forArgument(this);
        }
    }

    private void assertDoesNotBelongToParent() {
        if (this.belongsToParent()) {
            throw ArgumentBelongsToParentException.forArgumentAndParent(this, this.parent.getStoredElement());
        }
    }

    private void assertIsNotLinkedAnObject() {
        if (this.isLinkedToAnObject()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is alreay linked to an object");
        }
    }

    private boolean belongsToParent() {
        return this.parent != null;
    }

    private ControlParent getStoredParent() {
        this.assertBelongsToParent();
        return this.parent;
    }

    private void setMaxHeight(AbsoluteOrRelativeInt maxHeight) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(maxHeight);
        this.maxHeight.setValue(maxHeight);
    }

    private void setMaxWidth(AbsoluteOrRelativeInt maxWidth) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(maxWidth);
        this.maxWidth.setValue(maxWidth);
    }

    private void setMinHeight(AbsoluteOrRelativeInt minHeight) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(minHeight);
        this.minHeight.setValue(minHeight);
    }

    private void setMinWidth(AbsoluteOrRelativeInt minWidth) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(minWidth);
        this.minWidth.setValue(minWidth);
    }

    private void setParent(ControlParent parent) {
        Validator.assertThat(parent).thatIsNamed("parent").isNotNull();
        this.assertDoesNotBelongToParent();
        this.parent = parent;
        if (parent.isControl()) {
            parent.getStoredControl().getStoredStyle().addChild(this.getStoredStyle());
        }
    }

    private void setPresence(Presence presence) {
        this.presence.setValue(presence);
    }

    private void voidSetVisibility(boolean visible) {
        if (!visible) {
            this.setInvisible();
        } else {
            this.setVisible();
        }
    }
}

