/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.main;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.reflection.reflectiontool.ReflectionTool;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.webgui.main.Control;

public final class ControlFactoryUnit {
    private final LinkedList<Class<Control<?, ?>>> memberControlClasses = LinkedList.createEmpty();

    public boolean canCreateControlOfType(String type) {
        return this.containsControlClassWithName(type);
    }

    public Control<?, ?> createControlFromSpecification(INode<?> specification) {
        Control<?, ?> control = this.createControlOfType(specification.getHeader());
        control.resetFromSpecification(specification);
        return control;
    }

    public Control<?, ?> createControlOfType(String type) {
        Class<Control<?, ?>> controlClass = this.getControlClassByName(type);
        return ReflectionTool.createInstanceFromDefaultConstructorOfClass(controlClass);
    }

    public void registerControlClass(Class<Control<?, ?>> controlClass, Class<Control<?, ?>> ... controlClasses) {
        ContainerView<Class<Control<?, ?>>> allControlClasses = ContainerView.forElementAndArray(controlClass, controlClasses);
        for (Class clazz : allControlClasses) {
            this.assertDoesNotContainControlClassWithName(clazz.getSimpleName());
            this.memberControlClasses.addAtEnd(clazz);
        }
    }

    private void assertDoesNotContainControlClassWithName(String name) {
        if (this.containsControlClassWithName(name)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "contains already a Control class with the name '" + name + "'");
        }
    }

    private boolean containsControlClassWithName(String name) {
        return this.memberControlClasses.containsAny(cc -> cc.getSimpleName().equals(name));
    }

    private Class<Control<?, ?>> getControlClassByName(String name) {
        return this.memberControlClasses.getStoredFirst(cc -> cc.getSimpleName().equals(name));
    }
}

