/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.tech.math.bigdecimalmath;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.math.main.Calculator;
import ch.nolix.techapi.math.bigdecimalmath.IComplexNumber;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public final class ComplexNumber
implements IComplexNumber {
    private final BigDecimal realComponent;
    private final BigDecimal imaginaryComponent;

    public ComplexNumber(BigDecimal realComponent, BigDecimal imaginaryComponent) {
        Validator.assertThat(realComponent).thatIsNamed("real component").isNotNull();
        Validator.assertThat(imaginaryComponent).thatIsNamed("imaginary component").isNotNull();
        int decimalPlaces = Calculator.getMax(realComponent.scale(), imaginaryComponent.scale(), 10);
        this.realComponent = realComponent.setScale(decimalPlaces, RoundingMode.HALF_UP);
        this.imaginaryComponent = imaginaryComponent.setScale(decimalPlaces, RoundingMode.HALF_UP);
    }

    public ComplexNumber(BigDecimal realComponent, BigDecimal imaginaryComponent, int decimalPlaces) {
        Validator.assertThat(realComponent).thatIsNamed("real component").isNotNull();
        Validator.assertThat(imaginaryComponent).thatIsNamed("imaginary component").isNotNull();
        Validator.assertThat(decimalPlaces).thatIsNamed("big decimal scale").isPositive();
        this.realComponent = realComponent.setScale(decimalPlaces, RoundingMode.HALF_UP);
        this.imaginaryComponent = imaginaryComponent.setScale(decimalPlaces, RoundingMode.HALF_UP);
    }

    public ComplexNumber(double realComponent, double imaginaryComponent) {
        BigDecimal realComponentBigDecimal = BigDecimal.valueOf(realComponent);
        BigDecimal imaginaryComponentBigDecimal = BigDecimal.valueOf(imaginaryComponent);
        int decimalPlaces = Calculator.getMax(realComponentBigDecimal.scale(), imaginaryComponentBigDecimal.scale(), 10);
        this.realComponent = realComponentBigDecimal.setScale(decimalPlaces, RoundingMode.HALF_UP);
        this.imaginaryComponent = imaginaryComponentBigDecimal.setScale(decimalPlaces, RoundingMode.HALF_UP);
    }

    public ComplexNumber(double realComponent, double imaginaryComponent, int decimalPlaces) {
        Validator.assertThat(decimalPlaces).thatIsNamed("big decimal scale").isPositive();
        this.realComponent = BigDecimal.valueOf(realComponent).setScale(decimalPlaces, RoundingMode.HALF_UP);
        this.imaginaryComponent = BigDecimal.valueOf(imaginaryComponent).setScale(decimalPlaces, RoundingMode.HALF_UP);
    }

    @Override
    public int compareTo(IComplexNumber complexNumber) {
        Validator.assertThat(complexNumber).thatIsNamed("complex number").isNotNull();
        return this.getMagnitude().compareTo(complexNumber.getMagnitude());
    }

    public boolean equals(Object object) {
        if (object instanceof IComplexNumber) {
            IComplexNumber complexNumber = (IComplexNumber)object;
            return this.equalsComplexNumber(complexNumber);
        }
        return false;
    }

    @Override
    public ComplexNumber getConjugate() {
        return new ComplexNumber(this.realComponent, this.imaginaryComponent.negate(), this.getDecimalPlaces());
    }

    @Override
    public int getDecimalPlaces() {
        return this.realComponent.scale();
    }

    @Override
    public BigDecimal getImaginaryComponent() {
        return this.imaginaryComponent;
    }

    @Override
    public BigDecimal getMagnitude() {
        return this.realComponent.pow(2).add(this.imaginaryComponent.pow(2)).sqrt(MathContext.DECIMAL128).setScale(this.getScale(), RoundingMode.HALF_UP);
    }

    @Override
    public ComplexNumber getPower(int exponent) {
        Validator.assertThat(exponent).thatIsNamed("exponent").isPositive();
        ComplexNumber complexNumber = this;
        int i = 2;
        while (i <= exponent) {
            complexNumber = complexNumber.getProduct(this);
            ++i;
        }
        return complexNumber;
    }

    @Override
    public ComplexNumber getPower2() {
        return new ComplexNumber(this.realComponent.multiply(this.realComponent).subtract(this.imaginaryComponent.multiply(this.imaginaryComponent)), BigDecimal.valueOf(2.0).multiply(this.realComponent).multiply(this.imaginaryComponent), this.getDecimalPlaces());
    }

    @Override
    public ComplexNumber getPower3() {
        return new ComplexNumber(this.realComponent.pow(3).subtract(BigDecimal.valueOf(3.0).multiply(this.realComponent).multiply(this.imaginaryComponent.pow(2))), BigDecimal.valueOf(3.0).multiply(this.realComponent).pow(2).multiply(this.imaginaryComponent).subtract(this.imaginaryComponent.pow(3)), this.getDecimalPlaces());
    }

    @Override
    public ComplexNumber getPower4() {
        return new ComplexNumber(this.realComponent.pow(4).subtract(BigDecimal.valueOf(6.0).multiply(this.realComponent.pow(2)).multiply(this.imaginaryComponent.pow(2))).add(this.imaginaryComponent.pow(4)), BigDecimal.valueOf(4.0).multiply(this.realComponent.pow(3)).multiply(this.imaginaryComponent).subtract(BigDecimal.valueOf(4.0).multiply(this.realComponent).multiply(this.imaginaryComponent.pow(3))), this.getDecimalPlaces());
    }

    @Override
    public ComplexNumber getProduct(BigDecimal number) {
        return new ComplexNumber(this.realComponent.multiply(number), this.imaginaryComponent.multiply(number), this.getDecimalPlaces());
    }

    @Override
    public IComplexNumber getProduct(double number) {
        return this.getSum(BigDecimal.valueOf(number));
    }

    @Override
    public ComplexNumber getProduct(IComplexNumber complexNumber) {
        return new ComplexNumber(this.realComponent.multiply(complexNumber.getRealComponent()).subtract(this.imaginaryComponent.multiply(complexNumber.getImaginaryComponent())).setScale(this.getScale(), RoundingMode.HALF_UP), this.realComponent.multiply(complexNumber.getImaginaryComponent()).add(this.imaginaryComponent.multiply(complexNumber.getRealComponent())).setScale(this.getScale(), RoundingMode.HALF_UP), this.getDecimalPlaces());
    }

    @Override
    public BigDecimal getRealComponent() {
        return this.realComponent;
    }

    @Override
    public int getScale() {
        return this.realComponent.scale();
    }

    @Override
    public BigDecimal getSquaredMagnitude() {
        return this.realComponent.multiply(this.realComponent).add(this.imaginaryComponent.multiply(this.imaginaryComponent)).setScale(this.getScale(), RoundingMode.HALF_UP);
    }

    @Override
    public IComplexNumber getSum(BigDecimal number) {
        return new ComplexNumber(this.realComponent.add(number), this.imaginaryComponent, this.getDecimalPlaces());
    }

    @Override
    public ComplexNumber getSum(IComplexNumber complexNumber) {
        return new ComplexNumber(this.realComponent.add(complexNumber.getRealComponent()), this.imaginaryComponent.add(complexNumber.getImaginaryComponent()), this.getDecimalPlaces());
    }

    @Override
    public IComplexNumber getSum(double number) {
        return this.getSum(BigDecimal.valueOf(number));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public IComplexNumber inDecimalPlaces(int decimalPlaces) {
        return new ComplexNumber(this.realComponent, this.imaginaryComponent, decimalPlaces);
    }

    @Override
    public boolean isPureImaginary() {
        return this.realComponent.compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    public boolean isPureReal() {
        return this.imaginaryComponent.compareTo(BigDecimal.ZERO) == 0;
    }

    public String toString() {
        if (this.isPureReal()) {
            return this.realComponent.toString();
        }
        if (this.isPureImaginary()) {
            return String.valueOf(this.imaginaryComponent) + "i";
        }
        return String.valueOf(this.realComponent) + " + " + String.valueOf(this.imaginaryComponent) + "i";
    }

    private boolean equalsComplexNumber(IComplexNumber complexNumber) {
        return this.realComponent.equals(complexNumber.getRealComponent()) && this.imaginaryComponent.equals(complexNumber.getImaginaryComponent());
    }
}

