/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.commontypetool.arraytool;

import ch.nolix.core.errorcontrol.validator.Validator;
import java.util.function.Function;

public final class ArraySorter {
    private ArraySorter() {
    }

    public static <E, C extends Comparable<C>> void sortArray(E[] array, int oneBasedEndIndex, Function<E, C> comparableMapper) {
        Validator.assertThat(oneBasedEndIndex).thatIsNamed("one-based end index").isBetween(1, array.length);
        int zeroBasedEndIndex = oneBasedEndIndex - 1;
        Comparable[] comparableArray = ArraySorter.createComparableArray((Object[])array, (int)oneBasedEndIndex, comparableMapper);
        Object[] workElementArray = new Object[oneBasedEndIndex];
        Comparable[] workComparableArray = new Comparable[oneBasedEndIndex];
        ArraySorter.sortSection((Object[])array, (Comparable[])comparableArray, (int)0, (int)zeroBasedEndIndex, (Object[])workElementArray, (Comparable[])workComparableArray);
    }

    private static <E, C extends Comparable<C>> C[] createComparableArray(E[] array, int oneBasedEndIndex, Function<E, C> comparableMapper) {
        Comparable[] comparableArray = new Comparable[oneBasedEndIndex];
        int i = 0;
        while (i < oneBasedEndIndex) {
            comparableArray[i] = (Comparable)comparableMapper.apply(array[i]);
            ++i;
        }
        return comparableArray;
    }

    private static <E, C extends Comparable<C>> void sortSection(E[] elementArray, C[] comparableArray, int zeroBasedBeginIndex, int zeroBasedEndIndex, E[] workElementArray, C[] workComparableArray) {
        int elementToProcessCount = zeroBasedEndIndex - zeroBasedBeginIndex + 1;
        switch (elementToProcessCount) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (comparableArray[zeroBasedBeginIndex].compareTo(comparableArray[zeroBasedEndIndex]) <= 0) break;
                ArraySorter.swapElements(elementArray, zeroBasedBeginIndex, zeroBasedEndIndex);
                ArraySorter.swapElements(comparableArray, zeroBasedBeginIndex, zeroBasedEndIndex);
                break;
            }
            default: {
                ArraySorter.sortSectionWhenContainsMoreThanTwoElements((Object[])elementArray, comparableArray, (int)zeroBasedBeginIndex, (int)zeroBasedEndIndex, (Object[])workElementArray, workComparableArray);
            }
        }
    }

    private static void swapElements(Object[] array, int zeroBasedBeginIndex, int zeroBasedEndIndex) {
        Object leftElement = array[zeroBasedBeginIndex];
        array[zeroBasedBeginIndex] = array[zeroBasedEndIndex];
        array[zeroBasedEndIndex] = leftElement;
    }

    private static <E, C extends Comparable<C>> void sortSectionWhenContainsMoreThanTwoElements(E[] elementArray, C[] comparableArray, int zeroBasedBeginIndex, int zeroBasedEndIndex, E[] workElementArray, C[] workComparableArray) {
        int elementToProcessCount = zeroBasedEndIndex - zeroBasedBeginIndex + 1;
        int leftSectionZeroBasedEndIndex = zeroBasedBeginIndex + elementToProcessCount / 2;
        int rightSectionZeroBasedStartIndex = leftSectionZeroBasedEndIndex + 1;
        ArraySorter.sortSection((Object[])elementArray, comparableArray, (int)zeroBasedBeginIndex, (int)leftSectionZeroBasedEndIndex, (Object[])workElementArray, workComparableArray);
        ArraySorter.sortSection((Object[])elementArray, comparableArray, (int)rightSectionZeroBasedStartIndex, (int)zeroBasedEndIndex, (Object[])workElementArray, workComparableArray);
        ArraySorter.mergeSortedSections((Object[])elementArray, comparableArray, (int)zeroBasedBeginIndex, (int)leftSectionZeroBasedEndIndex, (int)zeroBasedEndIndex, (Object[])workElementArray, workComparableArray);
    }

    private static <E, C extends Comparable<C>> void mergeSortedSections(E[] elementArray, C[] comparableArray, int leftSectionZeroBasedBeginIndex, int leftSectionZeroBasedEndIndex, int rightSectionZeroBasedEndIndex, E[] workElementArray, C[] workComparableArray) {
        int leftSectionZeroBasedIndex = leftSectionZeroBasedBeginIndex;
        int rightSectionZeroBasedIndex = leftSectionZeroBasedEndIndex + 1;
        boolean movedElement = false;
        int i = 0;
        while (leftSectionZeroBasedIndex <= leftSectionZeroBasedEndIndex && rightSectionZeroBasedIndex <= rightSectionZeroBasedEndIndex) {
            if (comparableArray[leftSectionZeroBasedIndex].compareTo(comparableArray[rightSectionZeroBasedIndex]) > 0) {
                workElementArray[i] = elementArray[rightSectionZeroBasedIndex];
                workComparableArray[i] = comparableArray[rightSectionZeroBasedIndex];
                movedElement = true;
                ++rightSectionZeroBasedIndex;
            } else {
                workElementArray[i] = elementArray[leftSectionZeroBasedIndex];
                workComparableArray[i] = comparableArray[leftSectionZeroBasedIndex];
                ++leftSectionZeroBasedIndex;
            }
            ++i;
        }
        if (movedElement) {
            while (leftSectionZeroBasedIndex <= leftSectionZeroBasedEndIndex) {
                workElementArray[i] = elementArray[leftSectionZeroBasedIndex];
                workComparableArray[i] = comparableArray[leftSectionZeroBasedIndex];
                ++leftSectionZeroBasedIndex;
                ++i;
            }
            while (rightSectionZeroBasedIndex <= rightSectionZeroBasedEndIndex) {
                workElementArray[i] = elementArray[rightSectionZeroBasedIndex];
                workComparableArray[i] = comparableArray[rightSectionZeroBasedIndex];
                ++rightSectionZeroBasedIndex;
            }
            System.arraycopy(workElementArray, 0, elementArray, leftSectionZeroBasedBeginIndex, i);
            System.arraycopy(workComparableArray, 0, comparableArray, leftSectionZeroBasedBeginIndex, i);
        }
    }
}

