/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.containerview;

import ch.nolix.core.commontypetool.arraytool.ArrayIterator;
import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;

public final class ArrayContainerView<E>
extends AbstractExtendedContainer<E> {
    private static final ArrayContainerView<Object> EMPTY_ARRAY_CONTAINER_VIEW = new ArrayContainerView<Object>(new Object[0]);
    private final E[] array;

    private ArrayContainerView(E[] array) {
        Validator.assertThat(array).thatIsNamed("array").isNotNull();
        this.array = array;
    }

    public static <T> ArrayContainerView<T> createEmpty() {
        return EMPTY_ARRAY_CONTAINER_VIEW;
    }

    public static <T> ArrayContainerView<T> forArray(T[] array) {
        return new ArrayContainerView<T>(array);
    }

    @Override
    public int getCount() {
        return this.array.length;
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        Validator.assertThat(oneBasedIndex).thatIsNamed("1-based index").isBetween(0, this.getCount());
        int zeroBasedIndex = oneBasedIndex - 1;
        return this.array[zeroBasedIndex];
    }

    @Override
    public boolean isMaterialized() {
        return false;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return ArrayIterator.forArray(this.array);
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }
}

