/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.containerview;

import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.containerview.ArrayContainerView;
import ch.nolix.core.container.containerview.IterableContainerView;
import ch.nolix.core.container.containerview.MultiContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;

public final class ContainerView<E>
extends AbstractExtendedContainer<E> {
    private static final ContainerView<Object> EMPTY_ARRAY_CONTAINER_VIEW = new ContainerView(ImmutableList.createEmpty());
    private final IContainer<E> internalContainer;

    private ContainerView(IContainer<E> container) {
        Validator.assertThat(container).thatIsNamed("container").isNotNull();
        this.internalContainer = container;
    }

    public static <T> ContainerView<T> createEmpty() {
        return EMPTY_ARRAY_CONTAINER_VIEW;
    }

    public static <T> ContainerView<T> forArray(T[] array) {
        ArrayContainerView<T> container = ArrayContainerView.forArray(array);
        return new ContainerView<T>(container);
    }

    @SafeVarargs
    public static <T> ContainerView<T> forArrays(T[] ... arrays) {
        MultiContainerView<T> container = MultiContainerView.forArrays(arrays);
        return new ContainerView<T>(container);
    }

    public static <T> ContainerView<T> forElementAndArray(T element, T[] array) {
        Object[] arrayWithElement = new Object[]{element};
        MultiContainerView<Object> container = MultiContainerView.forArrays(arrayWithElement, array);
        return new ContainerView<Object>(container);
    }

    public static <T> ContainerView<T> forIterable(Iterable<T> iterable) {
        IterableContainerView<T> container = IterableContainerView.forIterable(iterable);
        return new ContainerView<T>(container);
    }

    public static <T> ContainerView<T> forIterableAndElement(Iterable<T> iterable, T element) {
        ImmutableList<T> iterableWithElement = ImmutableList.withElement(element);
        MultiContainerView container = MultiContainerView.forIterables(iterable, iterableWithElement);
        return new ContainerView(container);
    }

    @SafeVarargs
    public static <T> ContainerView<T> forIterables(Iterable<? extends T> ... iterables) {
        MultiContainerView<? extends T> container = MultiContainerView.forIterables(iterables);
        return new ContainerView<T>(container);
    }

    public boolean equals(Object object) {
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            return this.containsExactlyInSameOrder(iterable);
        }
        return false;
    }

    @Override
    public int getCount() {
        return this.internalContainer.getCount();
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        return this.internalContainer.getStoredAtOneBasedIndex(oneBasedIndex);
    }

    public int hashCode() {
        return this.internalContainer.hashCode();
    }

    @Override
    public boolean isMaterialized() {
        return this.internalContainer.isMaterialized();
    }

    @Override
    public CopyableIterator<E> iterator() {
        return this.internalContainer.iterator();
    }

    public String toString() {
        return this.internalContainer.toString();
    }
}

