/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.containerview;

import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.arraylist.ArrayList;
import ch.nolix.core.container.containerview.IterableContainerViewIterator;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsOutOfRangeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.Iterator;

public final class IterableContainerView<E>
extends AbstractExtendedContainer<E> {
    private final Iterable<E> iterable;

    public IterableContainerView() {
        this(ArrayList.createEmpty());
    }

    private <T extends E> IterableContainerView(Iterable<T> container) {
        Validator.assertThat(container).thatIsNamed("container").isNotNull();
        this.iterable = container;
    }

    public static <T> IterableContainerView<T> forIterable(Iterable<? extends T> iterable) {
        return new IterableContainerView(iterable);
    }

    @Override
    public int getCount() {
        int size = 0;
        Iterator<E> iterator = this.iterable.iterator();
        while (iterator.hasNext()) {
            ++size;
            iterator.next();
        }
        return size;
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        int i = 1;
        for (Object e : this) {
            if (i == oneBasedIndex) {
                return e;
            }
            ++i;
        }
        throw ArgumentIsOutOfRangeException.forArgumentAndArgumentNameAndRangeWithMinAndMax(oneBasedIndex, "1-based index", 1L, this.getCount());
    }

    @Override
    public boolean isMaterialized() {
        return false;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return IterableContainerViewIterator.forIterable(this.iterable);
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }
}

