/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.containerview;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.Iterator;

public final class IterableContainerViewIterator<E>
implements CopyableIterator<E> {
    private final Iterable<E> parentIterable;
    private final Iterator<E> internalIterator;
    private int iterationCount;

    private IterableContainerViewIterator(Iterable<E> parentIterable) {
        Validator.assertThat(parentIterable).thatIsNamed("parent iterable").isNotNull();
        this.parentIterable = parentIterable;
        this.internalIterator = parentIterable.iterator();
        this.iterationCount = 0;
    }

    private IterableContainerViewIterator(Iterable<E> parentIterable, int iterationCount) {
        Validator.assertThat(iterationCount).thatIsNamed("iteration count").isNotNegative();
        this.parentIterable = parentIterable;
        this.internalIterator = parentIterable.iterator();
        int i = 0;
        while (i < iterationCount) {
            this.internalIterator.next();
            ++i;
        }
        this.iterationCount = iterationCount;
    }

    public static <T> IterableContainerViewIterator<T> forIterable(Iterable<T> iterable) {
        return new IterableContainerViewIterator<T>(iterable);
    }

    @Override
    public CopyableIterator<E> getCopy() {
        return new IterableContainerViewIterator<E>(this.parentIterable, this.iterationCount);
    }

    @Override
    public boolean hasNext() {
        return this.internalIterator.hasNext();
    }

    @Override
    public E next() {
        ++this.iterationCount;
        return this.internalIterator.next();
    }
}

