/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.errormapping;

import ch.nolix.core.errorcontrol.errormapping.ErrorMessageExtractor;
import ch.nolix.core.independent.list.List;
import ch.nolix.coreapi.errorcontrol.errormapping.IErrorMessageExtractor;

public final class StackTraceMapper {
    private static final IErrorMessageExtractor ERROR_MESSAGE_EXTRACTOR = new ErrorMessageExtractor();

    private StackTraceMapper() {
    }

    public static String[] mapErrorToStackTrace(Throwable error) {
        List<String> list = new List<String>();
        StackTraceMapper.mapOwnStackTraceElementsOfErrorIntoList(error, list);
        Throwable cause = error.getCause();
        while (cause != null) {
            StackTraceMapper.mapCauseStackTraceIntoList(cause, list);
            cause = cause.getCause();
        }
        return List.createArrayFromList(list);
    }

    private static void mapCauseStackTraceIntoList(Throwable cause, List<String> list) {
        String errorMessage = ERROR_MESSAGE_EXTRACTOR.getMessageOfError(cause);
        list.addAtEnd("Cause: " + cause.getClass().getSimpleName() + ": " + errorMessage);
        StackTraceMapper.mapOwnStackTraceElementsOfErrorIntoList(cause, list);
    }

    private static void mapOwnStackTraceElementsOfErrorIntoList(Throwable cause, List<String> list) {
        StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement t = stackTraceElementArray[n2];
            list.addAtEnd(t.toString());
            ++n2;
        }
    }
}

