/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.invalidargumentexception;

import ch.nolix.core.errorcontrol.invalidargumentexception.AbstractInvalidArgumentException;
import ch.nolix.coreapi.errorcontrol.exceptionargumentbox.ArgumentNameDto;
import ch.nolix.coreapi.errorcontrol.exceptionargumentbox.ErrorPredicateDto;
import java.util.NoSuchElementException;

public final class ArgumentDoesNotHaveAttributeException
extends AbstractInvalidArgumentException {
    private static final String DEFAULT_ATTRIBUTE_NAME = "attribute";

    private ArgumentDoesNotHaveAttributeException(Object argument, Class<?> attributeType) {
        super(argument, new ErrorPredicateDto("does not have a " + ArgumentDoesNotHaveAttributeException.getNameOfAttributeType(attributeType)));
    }

    private ArgumentDoesNotHaveAttributeException(Object argument, String attributeName) {
        super(argument, new ErrorPredicateDto("does not have a " + ArgumentDoesNotHaveAttributeException.getValidatedAttributeNameFromAttributeName(attributeName)));
    }

    private ArgumentDoesNotHaveAttributeException(Object argument, String argumentName, Class<?> attributeType) {
        super(argument, new ArgumentNameDto(argumentName), new ErrorPredicateDto("does not have a " + ArgumentDoesNotHaveAttributeException.getNameOfAttributeType(attributeType)));
    }

    private ArgumentDoesNotHaveAttributeException(Object argument, String argumentName, String attributeName) {
        super(argument, new ArgumentNameDto(argumentName), new ErrorPredicateDto("does not have a " + ArgumentDoesNotHaveAttributeException.getValidatedAttributeNameFromAttributeName(attributeName)));
    }

    public static ArgumentDoesNotHaveAttributeException forArgumentAndAttributeName(Object argument, String attributeName) {
        return new ArgumentDoesNotHaveAttributeException(argument, attributeName);
    }

    public static ArgumentDoesNotHaveAttributeException forArgumentAndAttributeType(Object argument, Class<?> attributeType) {
        return new ArgumentDoesNotHaveAttributeException(argument, attributeType);
    }

    public static ArgumentDoesNotHaveAttributeException forArgumentAndArgumentNameAndAttributeName(Object argument, String argumentName, String attributeName) {
        return new ArgumentDoesNotHaveAttributeException(argument, argumentName, attributeName);
    }

    public static ArgumentDoesNotHaveAttributeException forArgumentAndArgumentNameAndAttributeType(String argumentName, Object argument, Class<?> attributeType) {
        return new ArgumentDoesNotHaveAttributeException(argument, argumentName, attributeType);
    }

    private static String getNameOfAttributeType(Class<?> attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException("The given attribute type is null.");
        }
        String name = attributeType.getSimpleName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return DEFAULT_ATTRIBUTE_NAME;
    }

    private static String getValidatedAttributeNameFromAttributeName(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("The given attribute name is null.");
        }
        if (attributeName.isBlank()) {
            throw new IllegalArgumentException("The given attribute name is blank.");
        }
        return attributeName;
    }

    public NoSuchElementException toNoSuchElementException() {
        return new NoSuchElementException(this.getMessage());
    }
}

