/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.performanceanalysis;

import ch.nolix.core.independent.math.NumberComparator;
import ch.nolix.core.independent.stopwatch.RuntimeMeter;
import ch.nolix.core.independent.stopwatch.StopWatch;
import ch.nolix.coreapi.errorcontrol.performanceanalysis.IPerformanceAnalyzer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.LongToDoubleFunction;

public final class PerformanceAnalyzer
implements IPerformanceAnalyzer {
    private static final RuntimeMeter RUNTIME_METER = new RuntimeMeter();

    @Override
    public <O> boolean onObjectsFromObjectSupplierActionHasGivenOrLowerTimeComplexity(IntFunction<O> objectSupplier, Consumer<O> action, LongToDoubleFunction timeComplexityFunction) {
        return this.onObjectsFromObjectSupplierActionRunsAtLeastOnceWithGivenOrLowerTimeComplexity(objectSupplier, action, timeComplexityFunction);
    }

    private <O> boolean onObjectsFromObjectSupplierActionRunsAtLeastOnceWithGivenOrLowerTimeComplexity(IntFunction<O> objectSupplier, Consumer<O> action, LongToDoubleFunction timeComplexityFunction) {
        StopWatch stopWatch = StopWatch.createStartedStopWatch();
        int maxRunCount = 5;
        while (stopWatch.getTotalRunningTimeInMilliseconds() < 5000L) {
            boolean resultIsFinal;
            boolean passed = this.onObjectsFromObjectSupplierUpToMaxRunCountActionRunsWithGivenOrLowerTimeComplexity(objectSupplier, maxRunCount, action, timeComplexityFunction);
            if (passed && (resultIsFinal = this.resultIsFinalAccordingToTotalRunningTimeInMillisecondsAndTotalRunCount(stopWatch.getTotalRunningTimeInMilliseconds(), maxRunCount))) {
                return true;
            }
            maxRunCount *= 5;
        }
        return false;
    }

    private <O> boolean onObjectsFromObjectSupplierUpToMaxRunCountActionRunsWithGivenOrLowerTimeComplexity(IntFunction<O> objectSupplier, int maxRunCount, Consumer<O> action, LongToDoubleFunction timeComplexityFunction) {
        double latestTimeComplexityInvariant = 0.0;
        int runCount = 5;
        while (runCount <= maxRunCount) {
            Optional<Double> optionalTimeComplexityInvariant = this.getOpionalTimeComplexityInvariantOfActionOnObjectFromObjectSupplierByRunCountAndTimeComplexityFunction(objectSupplier, runCount, action, timeComplexityFunction);
            if (optionalTimeComplexityInvariant.isPresent()) {
                Double timeComplexityInvariant = optionalTimeComplexityInvariant.get();
                double goodWillTimeComplexityInvariant = 1.1 * timeComplexityInvariant;
                if (latestTimeComplexityInvariant > 0.0 && goodWillTimeComplexityInvariant < latestTimeComplexityInvariant) {
                    return false;
                }
                latestTimeComplexityInvariant = NumberComparator.isZero(latestTimeComplexityInvariant) ? timeComplexityInvariant : 0.2 * latestTimeComplexityInvariant + 0.8 * timeComplexityInvariant;
            }
            runCount *= 5;
        }
        return true;
    }

    private <O> Optional<Double> getOpionalTimeComplexityInvariantOfActionOnObjectFromObjectSupplierByRunCountAndTimeComplexityFunction(IntFunction<O> objectSupplier, int runCount, Consumer<O> action, LongToDoubleFunction timeComplexityFunction) {
        int runtimeInMilliseconds = this.getRuntimeInMillisecondsOfActionOnObjectFromObjectSupplierByRunCount(objectSupplier, runCount, action);
        if (runtimeInMilliseconds > 10) {
            double timeComplexity = timeComplexityFunction.applyAsDouble(runCount);
            double timeComplexityInvariant = timeComplexity / (double)runtimeInMilliseconds;
            return Optional.of(timeComplexityInvariant);
        }
        return Optional.empty();
    }

    private <O> int getRuntimeInMillisecondsOfActionOnObjectFromObjectSupplierByRunCount(IntFunction<O> objectSupplier, int runCount, Consumer<O> action) {
        Object object = objectSupplier.apply(runCount);
        Runnable actionOnObject = () -> action.accept(object);
        return this.getRuntimeOfActionInMilliseconds(actionOnObject);
    }

    private int getRuntimeOfActionInMilliseconds(Runnable actionOnObject) {
        return (int)RUNTIME_METER.getRuntimeOfActionInMilliseconds(actionOnObject);
    }

    private boolean resultIsFinalAccordingToTotalRunningTimeInMillisecondsAndTotalRunCount(long totalRunningTimeInMilliseconds, int totalRunCount) {
        if (totalRunningTimeInMilliseconds > 5000L) {
            return totalRunCount >= 25;
        }
        return totalRunCount >= 1953125;
    }
}

