/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NonNegativeArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NonPositiveArgumentException;
import ch.nolix.core.errorcontrol.validator.MultiArgumentMediator;
import ch.nolix.core.independent.arraytool.ArrayTool;
import java.util.Iterator;

public final class MultiDoubleMediator
extends MultiArgumentMediator<Double> {
    private static final ArrayTool ARRAY_TOOL = new ArrayTool();

    public MultiDoubleMediator(Iterable<Double> arguments) {
        super(arguments);
    }

    public MultiDoubleMediator(double[] arguments) {
        super(ARRAY_TOOL.createIterable(arguments));
    }

    public void areBiggerThan(double value) {
        this.areNotNull();
        int i = 1;
        Iterator iterator = this.getStoredArguments().iterator();
        while (iterator.hasNext()) {
            double a = (Double)iterator.next();
            if (a <= value) {
                throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(a, i + "th argument", "is not bigger than " + value);
            }
            ++i;
        }
    }

    public void areNegative() {
        this.areNotNull();
        int i = 1;
        Iterator iterator = this.getStoredArguments().iterator();
        while (iterator.hasNext()) {
            double a = (Double)iterator.next();
            if (a > 0.0) {
                throw NonNegativeArgumentException.forArgumentAndArgumentName(a, i + "th argument");
            }
            ++i;
        }
    }

    public void arePositive() {
        this.areNotNull();
        int i = 1;
        Iterator iterator = this.getStoredArguments().iterator();
        while (iterator.hasNext()) {
            double a = (Double)iterator.next();
            if (a <= 0.0) {
                throw NonPositiveArgumentException.forArgumentAndArgumentName(a, i + "th argument");
            }
            ++i;
        }
    }

    public void areSmallerThan(double value) {
        this.areNotNull();
        int i = 1;
        Iterator iterator = this.getStoredArguments().iterator();
        while (iterator.hasNext()) {
            double a = (Double)iterator.next();
            if (a >= value) {
                throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(a, i + "the argument", "is not smaller than " + value);
            }
            ++i;
        }
    }
}

