/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotContainElementException;
import ch.nolix.core.errorcontrol.invalidargumentexception.EmptyArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.ArgumentMediator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.errorcontrol.validation.IOptionalMediator;
import java.util.Optional;

public class OptionalMediator<T>
extends ArgumentMediator<Optional<T>>
implements IOptionalMediator {
    protected OptionalMediator(Optional<T> argument) {
        super(argument);
    }

    protected OptionalMediator(String argumentName, Optional<T> argument) {
        super(argumentName, argument);
    }

    public static <T2> OptionalMediator<T2> forArgument(Optional<T2> argument) {
        return new OptionalMediator<T2>(argument);
    }

    public static <T2> OptionalMediator<T2> forArgumentNameAndArgument(String argumentName, Optional<T2> argument) {
        return new OptionalMediator<T2>(argumentName, argument);
    }

    @Override
    public final void containsEqualObject(Object object) {
        Optional argument = (Optional)this.getStoredArgument();
        if (argument == null || argument.isEmpty() || !argument.get().equals(object)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(argument, this.getArgumentName(), "does not contain an element that equals the given Object '" + String.valueOf(object) + "'");
        }
    }

    @Override
    public final void containsObject(Object object) {
        Optional argument = (Optional)this.getStoredArgument();
        if (argument == null || argument.isEmpty() || argument.get() == object) {
            throw ArgumentDoesNotContainElementException.forArgumentAndArgumentNameAndElement(argument, this.getArgumentName(), object);
        }
    }

    @Override
    public final void containsObjectOfType(Class<Object> type) {
        Validator.assertThat(type).thatIsNamed("type").isNotNull();
        Optional argument = (Optional)this.getStoredArgument();
        if (argument == null || argument.isEmpty() || !type.isAssignableFrom(argument.get().getClass())) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(argument, this.getArgumentName(), "does not contain an element that is of the given type '" + String.valueOf(type) + "'");
        }
    }

    @Override
    public final void isEmpty() {
        this.isNotNull();
        Optional argument = (Optional)this.getStoredArgument();
        if (argument.isEmpty()) {
            throw EmptyArgumentException.forArgumentAndArgumentName(argument, this.getArgumentName());
        }
    }

    @Override
    public final void isPresent() {
        this.isNotNull();
        Optional argument = (Optional)this.getStoredArgument();
        if (argument == null || argument.isEmpty()) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(argument, this.getArgumentName(), "is not present");
        }
    }
}

