/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.EmptyArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NegativeArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NonEmptyArgumentException;
import ch.nolix.core.errorcontrol.validator.ArgumentMediator;

public class StringMediator
extends ArgumentMediator<String> {
    protected StringMediator(String argument) {
        super(argument);
    }

    protected StringMediator(String argumentName, String argument) {
        super(argumentName, argument);
    }

    public static StringMediator forArgument(String argument) {
        return new StringMediator(argument);
    }

    public void hasLength(int length) {
        if (length < 0) {
            throw NegativeArgumentException.forArgumentAndArgumentName(length, "length");
        }
        this.isNotNull();
        if (((String)this.getStoredArgument()).length() != length) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "does not have the length " + length);
        }
    }

    public void isEmpty() {
        this.isNotNull();
        if (!((String)this.getStoredArgument()).isEmpty()) {
            throw NonEmptyArgumentException.forArgumentAndArgumentName(this.getStoredArgument(), this.getArgumentName());
        }
    }

    public void isNotEmpty() {
        this.isNotNull();
        if (((String)this.getStoredArgument()).isEmpty()) {
            throw EmptyArgumentException.forArgumentAndArgumentName(this.getStoredArgument(), this.getArgumentName());
        }
    }

    public void isNotBlank() {
        this.isNotNull();
        if (((String)this.getStoredArgument()).isBlank()) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is blank");
        }
    }

    public void isNotLongerThan(int maxLength) {
        this.isNotNull();
        if (((String)this.getStoredArgument()).length() > maxLength) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is longer than " + maxLength);
        }
    }

    public void isNotShorterThan(int minLength) {
        this.isNotNull();
        if (((String)this.getStoredArgument()).length() < minLength) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "has the length " + ((String)this.getStoredArgument()).length() + " and is therefore shorter than " + minLength);
        }
    }

    public void matches(String regularExpression) {
        this.isNotNull();
        if (!((String)this.getStoredArgument()).matches(regularExpression)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "does not match the regular expression '" + regularExpression + "'");
        }
    }

    public void startsWith(String prefix) {
        this.isNotNull();
        if (!((String)this.getStoredArgument()).startsWith(prefix)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "does not start with the prefix '" + prefix + "'");
        }
    }
}

