/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ClosedArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.baseendpoint.AbstractBaseEndPoint;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.coreapi.net.endpoint.IEndPoint;
import java.util.function.Consumer;

public abstract class AbstractEndPoint
extends AbstractBaseEndPoint
implements IEndPoint {
    private static final int CONNECT_TIMEOUT_IN_MILLISECONDS = 500;
    private String customTargetSlot;
    private Consumer<String> receiver;

    @Override
    public final String getCustomTargetSlot() {
        this.assertHasCustomTargetSlot();
        return this.customTargetSlot;
    }

    @Override
    public final boolean hasCustomTargetSlot() {
        return this.customTargetSlot != null;
    }

    @Override
    public final boolean hasReceiver() {
        return this.receiver != null;
    }

    @Override
    public final void setReceiver(Consumer<String> receiver) {
        Validator.assertThat(receiver).thatIsNamed("receiver").isNotNull();
        this.assertIsOpen();
        this.receiver = receiver;
    }

    protected final void assertIsOpen() {
        if (this.isClosed()) {
            throw ClosedArgumentException.forArgument(this);
        }
    }

    protected final Consumer<String> getStoredReceiver() {
        if (this.hasReceiver()) {
            return this.receiver;
        }
        FlowController.forMaxMilliseconds(500).waitUntil(this::hasReceiver);
        this.assertHasReceiver();
        return this.receiver;
    }

    protected final void setCustomTargetSlot(String customTargetSlot) {
        Validator.assertThat(customTargetSlot).thatIsNamed("custom target slot").isNotBlank();
        this.assertIsOpen();
        this.customTargetSlot = customTargetSlot;
    }

    private void assertHasCustomTargetSlot() {
        if (!this.hasCustomTargetSlot()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "target");
        }
    }

    private void assertHasReceiver() {
        if (!this.hasReceiver()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "receiver");
        }
    }
}

