/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint.AbstractServer;
import ch.nolix.core.net.endpoint.ServerListener;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;
import java.io.IOException;
import java.net.ServerSocket;

public final class Server
extends AbstractServer {
    public static final String DEFAULT_INITIAL_HTTP_MESSAGE = "HTTP/1.1 200 OK\nContent-Type: text/html; charset=UTF-8\n\n<!DOCTYPE html>\n<html>\n<head>\n<title>Nolix</title>\n<style>*{font-family: Calibri;}</style>\n</head>\n<body>\n<h1>Nolix</h1>\n<p>The requested server does not support web clients.</p>\n</body>\n</html>\n";
    private final int port;
    private final String initialHttpMessage;
    private final ServerSocket serverSocket;

    private Server(int port, String initialHttpMessage) {
        Validator.assertThat(port).isBetween(0, 65535);
        Validator.assertThat(initialHttpMessage).thatIsNamed("initial HTTP message").isNotBlank();
        this.port = port;
        this.initialHttpMessage = initialHttpMessage;
        try {
            this.serverSocket = new ServerSocket(this.getPort());
            this.serverSocket.setReuseAddress(true);
        }
        catch (IOException ioException) {
            throw WrapperException.forError(ioException);
        }
        this.createServerListener();
    }

    public static Server forHttpPort() {
        return Server.forPort(80);
    }

    public static Server forPort(int port) {
        return new Server(port, DEFAULT_INITIAL_HTTP_MESSAGE);
    }

    public static Server forPortAndInitialHttpMessage(int port, String initialHttpMessage) {
        return new Server(port, initialHttpMessage);
    }

    public String getInitialHttpMessage() {
        return this.initialHttpMessage;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public SecurityMode getSecurityMode() {
        return SecurityMode.NONE;
    }

    @Override
    public void noteClose() {
        try {
            this.serverSocket.close();
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    ServerSocket internalGetStoredServerSocket() {
        return this.serverSocket;
    }

    private void createServerListener() {
        ServerListener.forServer(this);
    }
}

