/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint.WebSocketEndPoint;
import ch.nolix.core.net.websocket.WebSocketCompleteMessage;
import ch.nolix.core.programcontrol.worker.AbstractBatchWorker;

final class WebEndPointMessageListener
extends AbstractBatchWorker {
    private final WebSocketEndPoint parentWebEndPoint;

    private WebEndPointMessageListener(WebSocketEndPoint parentWebEndPoint) {
        Validator.assertThat(parentWebEndPoint).thatIsNamed("parent WebEndPoint").isNotNull();
        this.parentWebEndPoint = parentWebEndPoint;
        this.start();
    }

    public static WebEndPointMessageListener forWebEndPoint(WebSocketEndPoint webSocketEndPoint) {
        return new WebEndPointMessageListener(webSocketEndPoint);
    }

    @Override
    protected void runStep() {
        WebSocketCompleteMessage message = new WebSocketCompleteMessage(this.parentWebEndPoint::isOpen, this.parentWebEndPoint.getStoredInputStream(), this.parentWebEndPoint::receiveControlFrame);
        this.receiveMessage(message);
    }

    @Override
    protected boolean shouldRunNextStep() {
        return this.parentWebEndPoint.isOpen();
    }

    private void receiveMessage(String message) {
        if (!message.isEmpty()) {
            this.parentWebEndPoint.receiveRawMessageInBackground(message);
        }
    }

    private void receiveMessage(WebSocketCompleteMessage message) {
        if (message.isComplete()) {
            this.receiveMessage(message.getMessage());
        }
    }
}

