/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.ssl;

import ch.nolix.core.environment.filesystem.FileSystemAccessor;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.net.ssl.ISslCertificateKeyReader;

public final class SslCertificateKeyReader
implements ISslCertificateKeyReader {
    public String getKeyFromPemFileLines(IContainer<String> pemFileLines) {
        IContainer<String> keyLines = this.getKeyLinesFromPemFileLines(pemFileLines);
        return keyLines.toConcatenatedString();
    }

    public boolean isKeyLine(String line) {
        return !line.isBlank() && !line.trim().equals("-----BEGIN PRIVATE KEY-----") && !line.trim().equals("-----END PRIVATE KEY-----");
    }

    @Override
    public String readKeyFromPemFile(String pemFilePath) {
        ILinkedList<String> pemFileLines = FileSystemAccessor.readFileToLines(pemFilePath);
        return this.getKeyFromPemFileLines(pemFileLines);
    }

    private IContainer<String> getKeyLinesFromPemFileLines(IContainer<String> pemFileLines) {
        return pemFileLines.getStoredSelected(this::isKeyLine);
    }
}

