/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.websocket;

import ch.nolix.core.commontypetool.arraytool.ArrayTool;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnsupportedCaseException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.websocket.WebSocketFrameFirstNibble;
import ch.nolix.core.net.websocket.WebSocketFramePayloadLength;
import ch.nolix.coreapi.net.websocket.WebSocketFrameOpcodeMeaning;
import ch.nolix.coreapi.net.websocket.WebSocketFramePayloadLengthType;
import ch.nolix.coreapi.net.websocket.WebSocketFrameType;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;

public final class WebSocketFrame {
    private static final int MASK_LENGTH_IN_BYTES = 4;
    private static final ArrayTool ARRAY_TOOL = new ArrayTool();
    private final WebSocketFrameFirstNibble firstNibble;
    private final WebSocketFramePayloadLength payloadLength;
    private final byte[] payload;
    private final byte[] maskingKey;

    public WebSocketFrame(boolean mFINBit, WebSocketFrameOpcodeMeaning opcode, boolean maskBit, byte[] payload) {
        Validator.assertThat(payload).thatIsNamed("payload").isNotNull();
        this.firstNibble = new WebSocketFrameFirstNibble(mFINBit, opcode, maskBit, payload.length);
        this.payloadLength = new WebSocketFramePayloadLength(payload.length);
        this.payload = payload;
        this.maskingKey = null;
    }

    public WebSocketFrame(boolean mFINBit, WebSocketFrameOpcodeMeaning opcode, boolean maskBit, String payload) {
        this(mFINBit, opcode, maskBit, payload.getBytes(StandardCharsets.UTF_8));
    }

    public WebSocketFrame(InputStream inputStream) {
        try {
            this.firstNibble = WebSocketFrameFirstNibble.fromNibble(inputStream.readNBytes(2));
            this.payloadLength = this.calculatePayloadLength(inputStream);
            this.maskingKey = (byte[])(this.getMaskBit() ? inputStream.readNBytes(4) : null);
            if (this.payloadLength.getValue() > Integer.MAX_VALUE) {
                throw UnsupportedCaseException.forCase("The payload is longer than 2147483647.");
            }
            this.payload = inputStream.readNBytes((int)this.getPayloadLength());
            if (this.maskingKey != null) {
                int i = 0;
                while (i < this.payload.length) {
                    this.payload[i] = (byte)(this.payload[i] ^ this.maskingKey[i & 3]);
                    ++i;
                }
            }
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    public static WebSocketFrame createPongFrameFor(WebSocketFrame pingFrame) {
        if (!pingFrame.isPingFrame()) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(pingFrame, "ping frame", "is actually not a ping frame");
        }
        return new WebSocketFrame(true, WebSocketFrameOpcodeMeaning.PONG, false, pingFrame.getPayload());
    }

    public WebSocketFrame createPongFrame() {
        if (!this.isPingFrame()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is not a ping frame");
        }
        return new WebSocketFrame(true, WebSocketFrameOpcodeMeaning.PONG, false, this.payload);
    }

    public boolean getFINBit() {
        return this.firstNibble.getFINBit();
    }

    public WebSocketFrameType getFrameType() {
        if (this.isControlFrame()) {
            return WebSocketFrameType.CONTROL_FRAME;
        }
        if (this.isDataFrame()) {
            return WebSocketFrameType.DATA_FRAME;
        }
        throw InvalidArgumentException.forArgument(this);
    }

    public BigDecimal getLengthInBytes() {
        BigDecimal byteRepresentationLength = BigDecimal.valueOf(2L);
        switch (this.getPayloadLengthType()) {
            case BITS_16: {
                byteRepresentationLength = byteRepresentationLength.add(BigDecimal.valueOf(2L));
                break;
            }
            case BITS_64: {
                byteRepresentationLength = byteRepresentationLength.add(BigDecimal.valueOf(8L));
            }
        }
        if (this.masksPayload()) {
            byteRepresentationLength = byteRepresentationLength.add(BigDecimal.valueOf(4L));
        }
        byteRepresentationLength = byteRepresentationLength.add(BigDecimal.valueOf(this.getPayloadLength()));
        return byteRepresentationLength;
    }

    public boolean getMaskBit() {
        return this.firstNibble.getMaskBit();
    }

    public int getMaskLength() {
        if (this.masksPayload()) {
            return 4;
        }
        return 0;
    }

    public WebSocketFrameOpcodeMeaning getOpcodeMeaning() {
        return this.firstNibble.getOpcodeMeaning();
    }

    public long getPayloadLength() {
        return this.payloadLength.getValue();
    }

    public WebSocketFramePayloadLengthType getPayloadLengthType() {
        return this.firstNibble.getPayloadLengthType();
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public boolean isControlFrame() {
        return switch (this.getOpcodeMeaning()) {
            case WebSocketFrameOpcodeMeaning.CONNECTION_CLOSE, WebSocketFrameOpcodeMeaning.PING, WebSocketFrameOpcodeMeaning.PONG -> true;
            default -> false;
        };
    }

    public boolean isDataFrame() {
        return switch (this.getOpcodeMeaning()) {
            case WebSocketFrameOpcodeMeaning.TEXT_FRAME, WebSocketFrameOpcodeMeaning.BINARY_FRAME -> true;
            default -> false;
        };
    }

    public boolean isFinalFragment() {
        return this.getFINBit();
    }

    public boolean isPingFrame() {
        return this.getOpcodeMeaning() == WebSocketFrameOpcodeMeaning.PING;
    }

    public boolean isPongFrame() {
        return this.getOpcodeMeaning() == WebSocketFrameOpcodeMeaning.PONG;
    }

    public boolean masksPayload() {
        return this.getMaskBit();
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[this.getLengthInBytes().intValue()];
        bytes[0] = this.firstNibble.getByte1();
        bytes[1] = this.firstNibble.getByte2();
        int i = 2;
        byte[] payloadLengthBytes = this.payloadLength.toBytes();
        WebSocketFramePayloadLengthType payloadLengthType = this.getPayloadLengthType();
        switch (payloadLengthType) {
            case BITS_7: {
                break;
            }
            case BITS_16: {
                bytes[2] = payloadLengthBytes[0];
                bytes[3] = payloadLengthBytes[1];
                i += 2;
                break;
            }
            case BITS_64: {
                this.writePayloadLengthIntoBytesWhenPayloadLengthTypeisBits64(bytes, payloadLengthBytes);
                i += 8;
                break;
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)payloadLengthType);
            }
        }
        if (this.firstNibble.getMaskBit()) {
            i = ARRAY_TOOL.onArray(bytes).fromIndex(i).write(this.maskingKey).andGetNextIndex();
        }
        ARRAY_TOOL.onArray(bytes).fromIndex(i).write(this.payload);
        return bytes;
    }

    private WebSocketFramePayloadLength calculatePayloadLength(InputStream inputStream) throws IOException {
        return switch (this.getPayloadLengthType()) {
            case WebSocketFramePayloadLengthType.BITS_7 -> this.calculatePayloadLengthWhenPayloadLengthIs7Bits();
            case WebSocketFramePayloadLengthType.BITS_16 -> this.calculatePayloadLengthWhenPayloadLengthIs16Bits(inputStream);
            case WebSocketFramePayloadLengthType.BITS_64 -> this.calculatePayloadLengthWhenPayloadLengthIs64Bits(inputStream);
            default -> throw InvalidArgumentException.forArgument((Object)this.getPayloadLengthType());
        };
    }

    private WebSocketFramePayloadLength calculatePayloadLengthWhenPayloadLengthIs7Bits() {
        return new WebSocketFramePayloadLength(this.firstNibble.get7BitsPayloadLength());
    }

    private WebSocketFramePayloadLength calculatePayloadLengthWhenPayloadLengthIs16Bits(InputStream inputStream) throws IOException {
        byte[] headerNext2Bytes = inputStream.readNBytes(2);
        return new WebSocketFramePayloadLength(256L * (long)(headerNext2Bytes[0] & 0xFF) + (long)(headerNext2Bytes[1] & 0xFF));
    }

    private WebSocketFramePayloadLength calculatePayloadLengthWhenPayloadLengthIs64Bits(InputStream inputStream) throws IOException {
        byte[] headerNext8Bytes = inputStream.readNBytes(8);
        return new WebSocketFramePayloadLength(0x100000000000000L * (long)(headerNext8Bytes[0] & 0xFF) + 0x1000000000000L * (long)(headerNext8Bytes[1] & 0xFF) + 0x10000000000L * (long)(headerNext8Bytes[2] & 0xFF) + 0x100000000L * (long)(headerNext8Bytes[3] & 0xFF) + 0x1000000L * (long)(headerNext8Bytes[4] & 0xFF) + 65536L * (long)(headerNext8Bytes[5] & 0xFF) + 256L * (long)(headerNext8Bytes[6] & 0xFF) + (long)(headerNext8Bytes[7] & 0xFF));
    }

    private void writePayloadLengthIntoBytesWhenPayloadLengthTypeisBits64(byte[] bytes, byte[] payloadLengthBytes) {
        bytes[2] = payloadLengthBytes[0];
        bytes[3] = payloadLengthBytes[1];
        bytes[4] = payloadLengthBytes[2];
        bytes[5] = payloadLengthBytes[3];
        bytes[6] = payloadLengthBytes[4];
        bytes[7] = payloadLengthBytes[5];
        bytes[8] = payloadLengthBytes[6];
        bytes[9] = payloadLengthBytes[7];
    }
}

