/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.logging.Logger;
import ch.nolix.core.errorcontrol.validator.Validator;
import java.util.function.Supplier;

final class ResultJobExecutor<R>
extends Thread {
    private final Supplier<R> resultJob;
    private R result;
    private boolean running = true;
    private Throwable error;

    private ResultJobExecutor(Supplier<R> resultJob) {
        Validator.assertThat(resultJob).thatIsNamed("result job").isNotNull();
        this.resultJob = resultJob;
        this.start();
    }

    public static <R> ResultJobExecutor<R> forResultJob(Supplier<R> resultJob) {
        return new ResultJobExecutor<R>(resultJob);
    }

    public boolean caughtError() {
        return this.error != null;
    }

    public Throwable getError() {
        if (this.error == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "error");
        }
        return this.error;
    }

    public R getResult() {
        if (!this.isFinished()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is not finished");
        }
        if (this.caughtError()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "has caught an error");
        }
        return this.result;
    }

    public boolean isFinished() {
        return !this.isRunning();
    }

    public boolean isFinsishedSuccessfully() {
        return this.isFinished() && !this.caughtError();
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        try {
            try {
                this.result = this.resultJob.get();
            }
            catch (Throwable paramError) {
                this.error = paramError;
                Logger.logError(paramError);
                this.running = false;
            }
        }
        finally {
            this.running = false;
        }
    }
}

