/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.sql.connection;

import ch.nolix.core.resourcecontrol.closecontroller.UncloseableCloseController;
import ch.nolix.core.resourcecontrol.resourcevalidator.ResourceValidator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.coreapi.sql.model.ISqlRecord;
import ch.nolix.coreapi.sql.sqlproperty.SqlDatabaseEngine;

public final class UncloseableSqlConnection
implements ISqlConnection {
    private final ISqlConnection sqlConnection;

    private UncloseableSqlConnection(ISqlConnection sqlConnection) {
        ResourceValidator.assertIsOpen(sqlConnection);
        this.sqlConnection = sqlConnection;
    }

    public static UncloseableSqlConnection forSqlConnection(ISqlConnection sqlConnection) {
        if (sqlConnection instanceof UncloseableSqlConnection) {
            UncloseableSqlConnection uncloseableSqlConnection = (UncloseableSqlConnection)sqlConnection;
            return uncloseableSqlConnection;
        }
        return new UncloseableSqlConnection(sqlConnection);
    }

    @Override
    public void executeStatement(String statement, String ... statements) {
        this.sqlConnection.executeStatement(statement, statements);
    }

    @Override
    public void executeStatements(IContainer<String> statements) {
        this.sqlConnection.executeStatements(statements);
    }

    @Override
    public SqlDatabaseEngine getDatabaseEngine() {
        return this.sqlConnection.getDatabaseEngine();
    }

    @Override
    public IContainer<ISqlRecord> getRecordsFromQuery(String query) {
        return this.sqlConnection.getRecordsFromQuery(query);
    }

    @Override
    public ISqlRecord getSingleRecordFromQuery(String query) {
        return this.sqlConnection.getSingleRecordFromQuery(query);
    }

    @Override
    public ICloseController getStoredCloseController() {
        return new UncloseableCloseController();
    }

    @Override
    public void noteClose() {
    }
}

