/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.sql.connectionpool;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.usercontrol.Credential;
import ch.nolix.core.resourcecontrol.resourcepool.AbstractResourcePool;
import ch.nolix.core.sql.connection.AbstractSqlConnection;
import ch.nolix.core.sql.connectionpool.SqlConnectionFactory;
import ch.nolix.core.sql.connectionpool.WrapperSqlConnection;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;
import ch.nolix.coreapi.sql.connection.ISqlDatabaseTarget;
import ch.nolix.coreapi.sql.sqlproperty.SqlDatabaseEngine;

public final class SqlConnectionPool
extends AbstractResourcePool<WrapperSqlConnection, AbstractSqlConnection>
implements ISqlDatabaseTarget {
    private static final SecurityMode SECURITY_MODE_FOR_CONNECTIONS = SecurityMode.NONE;
    private static final SqlConnectionFactory SQL_CONNECTION_FACTORY = new SqlConnectionFactory();
    private final String ipOrDomain;
    private final int port;
    private final String databaseName;
    private final SqlDatabaseEngine sqlDatabaseEngine;
    private final Credential credential;

    SqlConnectionPool(String ipOrDomain, int port, String databaseName, SqlDatabaseEngine sqlDatabaseEngine, String loginName, String loginPassword) {
        Validator.assertThat(ipOrDomain).thatIsNamed("ip or address name").isNotBlank();
        Validator.assertThat(port).thatIsNamed("port").isBetween(0, 65535);
        Validator.assertThat(databaseName).thatIsNamed("database name").isNotBlank();
        Validator.assertThat(sqlDatabaseEngine).thatIsNamed(SqlDatabaseEngine.class).isNotNull();
        this.ipOrDomain = ipOrDomain;
        this.port = port;
        this.databaseName = databaseName;
        this.sqlDatabaseEngine = sqlDatabaseEngine;
        this.credential = Credential.withLoginNameAndPassword(loginName, loginPassword);
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getIpOrDomain() {
        return this.ipOrDomain;
    }

    @Override
    public String getLoginName() {
        return this.credential.getLoginName();
    }

    @Override
    public String getLoginPassword() {
        return this.credential.getPassword();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public SecurityMode getSecurityModeForConnection() {
        return SECURITY_MODE_FOR_CONNECTIONS;
    }

    @Override
    public SqlDatabaseEngine getSqlDatabaseEngine() {
        return this.sqlDatabaseEngine;
    }

    @Override
    public String toUrl() {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "toUrl");
    }

    @Override
    protected AbstractSqlConnection createResource() {
        return SQL_CONNECTION_FACTORY.createSqlConnectionForSqlConnectionPool(this);
    }

    @Override
    protected WrapperSqlConnection createWrapperResourceWithResource(AbstractSqlConnection resource) {
        return WrapperSqlConnection.forSqlConnection(resource);
    }
}

