/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.web.htmlelementmodel;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlAttribute;

public final class HtmlAttribute
implements IHtmlAttribute {
    private final String name;
    private final String value;

    private HtmlAttribute(String name, String value) {
        if (name == null) {
            throw ArgumentIsNullException.forArgumentName("key");
        }
        if (value == null) {
            throw ArgumentIsNullException.forArgumentName("value");
        }
        this.name = name;
        this.value = value;
    }

    public static HtmlAttribute fromHtmlAttribute(IHtmlAttribute htmlAttribute) {
        if (htmlAttribute instanceof HtmlAttribute) {
            HtmlAttribute concreteHtmlAttribute = (HtmlAttribute)htmlAttribute;
            return concreteHtmlAttribute;
        }
        return HtmlAttribute.withNameAndValue(htmlAttribute.getName(), htmlAttribute.getValue());
    }

    public static HtmlAttribute withNameAndValue(String name, int value) {
        return HtmlAttribute.withNameAndValue(name, String.valueOf(value));
    }

    public static HtmlAttribute withNameAndValue(String name, String value) {
        return new HtmlAttribute(name, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getName() + "=\"" + this.getValue() + "\"";
    }
}

