/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.core.resourcecontrol.resourcevalidator.ResourceValidator;
import ch.nolix.system.application.main.AbstractBackendClient;
import ch.nolix.system.application.main.AbstractClient;
import ch.nolix.system.application.main.AbstractSession;

public final class BackendClientSessionManager<C extends AbstractBackendClient<C, S>, S> {
    private static final int MAX_WAIT_TIME_FOR_SESSION_IN_MILLISECONDS = 10000;
    private final C parentClient;
    private AbstractSession<C, S> currentSession;
    private final LinkedList<AbstractSession<C, S>> sessionStack = LinkedList.createEmpty();

    private BackendClientSessionManager(C parentClient) {
        Validator.assertThat(parentClient).thatIsNamed("parent client").isNotNull();
        this.parentClient = parentClient;
    }

    public static <C2 extends AbstractBackendClient<C2, S2>, S2> BackendClientSessionManager<C2, S2> forClient(C2 client) {
        return new BackendClientSessionManager(client);
    }

    public boolean containsCurrentSession() {
        return this.currentSession != null;
    }

    public boolean containsNextSession() {
        return this.containsCurrentSession() && this.getSessionStackSize() > this.getCurrentSessionIndex();
    }

    public boolean containsPreviousSession() {
        return this.containsCurrentSession() && this.getCurrentSessionIndex() > 1;
    }

    public boolean currentSessionIsTopSession() {
        return this.containsCurrentSession() && this.getStoredCurrentSession() == this.getStoredTopSession();
    }

    public AbstractSession<C, S> getStoredCurrentSession() {
        FlowController.forMaxMilliseconds(10000).waitUntil(this::containsCurrentSession);
        this.assertContainsCurrentSession();
        return this.currentSession;
    }

    public int getSessionStackSize() {
        return this.sessionStack.getCount();
    }

    public void popCurrentSession() {
        this.popCurrentSessionFromStack();
        this.closeClientOrReinitializeCurrentSession();
    }

    public void popCurrentSessionAndForwardGivenResult(Object result) {
        this.getStoredCurrentSession().internalSetResult(result);
        this.popCurrentSessionFromStack();
    }

    public void pushSession(AbstractSession<C, S> session) {
        Validator.assertThat(session).isOfType(AbstractSession.class);
        session.internalSetParentClient(this.parentClient);
        this.sessionStack.addAtEnd(session);
        this.currentSession = session;
        this.initializeSession(session);
    }

    public <R> R pushSessionAndGetResult(AbstractSession<C, S> session) {
        this.pushSession(session);
        FlowController.waitUntil(() -> ((AbstractClient)this.parentClient).isClosed() || !session.belongsToClient());
        ResourceValidator.assertIsOpen(this.parentClient);
        return (R)session.internalGetStoredResult();
    }

    public void setCurrentSession(AbstractSession<C, S> session) {
        this.popCurrentSessionFromStack();
        this.pushSession(session);
    }

    private void assertContainsCurrentSession() {
        if (!this.containsCurrentSession()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "current Session");
        }
    }

    private void assertContainsCurrentSessionAsTopSession() {
        this.assertContainsCurrentSession();
        if (!this.currentSessionIsTopSession()) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredCurrentSession(), "current Session", "is not the top Session");
        }
    }

    private void closeClientOrReinitializeCurrentSession() {
        if (!this.containsCurrentSession()) {
            this.parentClient.close();
        } else {
            this.initializeSession(this.getStoredCurrentSession());
        }
    }

    private int getCurrentSessionIndex() {
        return this.sessionStack.getOneBasedIndexOfFirstOccurrenceOf(this.getStoredCurrentSession());
    }

    private AbstractSession<C, S> getStoredTopSession() {
        return (AbstractSession)this.sessionStack.getStoredLast();
    }

    private void initializeSession(AbstractSession<C, S> session) {
        if (this.parentClient.isOpen()) {
            session.fullInitialize();
        }
        if (this.parentClient.isOpen() && session.belongsToClient()) {
            session.refresh();
        }
    }

    private void popCurrentSessionFromStack() {
        this.assertContainsCurrentSessionAsTopSession();
        this.popCurrentSessionFromStackWhenContainsCurrentSessionAsTopSession();
    }

    private void popCurrentSessionFromStackWhenContainsCurrentSessionAsTopSession() {
        this.popTopSessionFromSessionStackWhenContainsCurrentSessionAsTopSession();
        this.setOrClearCurrentSessionAccordingToSessionStack();
    }

    private void popTopSessionFromSessionStackWhenContainsCurrentSessionAsTopSession() {
        AbstractSession<C, S> topSession = this.sessionStack.removeAndGetStoredLast();
        topSession.internalRemoveParentClient();
    }

    private void setOrClearCurrentSessionAccordingToSessionStack() {
        this.currentSession = this.sessionStack.isEmpty() ? null : (AbstractSession)this.sessionStack.getStoredLast();
    }
}

