/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.attribute.mandatoryattribute.INameHolder;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.systemapi.element.property.IProperty;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class MutableOptionalSpecificationValueExtractor
implements IProperty,
INameHolder {
    private final String name;
    private final Consumer<INode<?>> setter;
    private final BooleanSupplier valuePresenceChecker;
    private final Supplier<Node> getter;

    public MutableOptionalSpecificationValueExtractor(String name, Consumer<INode<?>> setter, BooleanSupplier valuePresenceChecker, Supplier<Node> getter) {
        Validator.assertThat(name).thatIsNamed("Name").isNotBlank();
        Validator.assertThat(setter).thatIsNamed("setter").isNotNull();
        Validator.assertThat(valuePresenceChecker).thatIsNamed("value presence checker").isNotNull();
        Validator.assertThat(getter).thatIsNamed("getter").isNotNull();
        this.name = name;
        this.setter = setter;
        this.valuePresenceChecker = valuePresenceChecker;
        this.getter = getter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean addedOrChangedAttribute(INode<?> attribute) {
        if (attribute.hasHeader(this.getName())) {
            this.setter.accept(attribute);
            return true;
        }
        return false;
    }

    @Override
    public void fillUpAttributesInto(ILinkedList<INode<?>> list) {
        if (this.valuePresenceChecker.getAsBoolean()) {
            list.addAtEnd(this.getter.get());
        }
    }
}

